#include "longbuf.h"

struct node {
  char *msg ;
  size_t size ;
  Seqno seqno ;
  TV last ;
  struct node *next ;
} ;

typedef struct node Node ;

static Node *head = NULL ;
static double max_idle = 1.0 ;


void longbuf_add(char *msg, size_t size, Seqno seqno, TV last) {
  Node *p ;

  p = Malloc(sizeof(Node)) ;
  p->msg = Malloc(size) ;
  memcpy(p->msg, msg, size) ;
  p->size = size ;
  p->last = last ;
  p->seqno = seqno ;
  p->next = head ;
  head = p ;
  return ;
}


UL longbuf_nmsgs(void) {
  UL cnt ;
  Node *p ;

  cnt = 0 ;
  p = head ;
  while (p != NULL) {
    cnt++ ;
    p = p->next ;
  }
  return(cnt) ;
}


char *longbuf_get(Seqno seqno, size_t *size) {
  Node *p ;

  p = head ;
  while (p != NULL) {
    if (p->seqno == seqno) {
      (*size) = p->size ;
      return(p->msg) ;
    } else {
      p = p->next ;
    }
  }
  (*size) = 0 ;
  return(NULL) ;
}


void longbuf_check(void) {
  TV now, thresh ;
  Node *p, *pre ;

  now = Gettimeofday() ;
  thresh = time_sub(now, time_of_double(max_idle)) ;
  p = head ;
  pre = NULL ;
  while (p != NULL) {
    if (time_gt(thresh, p->last)) {
      if (pre != NULL) {
	pre->next = p->next ;
      } else {
	head = p->next ;
      }
      free(p->msg) ;
      free(p) ;
      return ;
    }
    pre = p ;
    p = p->next ;
  }
  return ;
}


char *longbuf_take(Seqno seqno, size_t *size) {
  Node *p, *pre ;
  char *msg ;

  p = head ;
  pre = NULL ;
  while (p != NULL) {
    if (p->seqno == seqno) {
      if (pre != NULL) {
	pre->next = p->next ;
      } else {
	head = p->next ;
      }
      msg = p->msg ;
      (*size) = p->size ;
      free(p) ;
      return(msg) ;
    }
    pre = p ;
    p = p->next ;
  }
  printf("Error[mq]: seqno %lu not found.\n", seqno) ;
  exit(1) ;
}
