#ifndef _IQ_H
#define _IQ_H

#include "util.h"
#include "timer.h"

#define IQ_DATA     2
#define IQ_PENDING  3
#define IQ_LOST     4

struct item {
  Type type ;

  /* relevant for IQ_DATA */
  char *msg ;
  size_t size ;
  TV first, last ;
  bool local_cast_pending ;
  timer_id local_cast_timer ;
  double rtt ;
  SAin target ;

  /* relevant for IQ_PENDING */
  UL local_try, remote_try ;
  timer_id local_timer, remote_timer ;
  TV ts, recv_time ;
  bool waiting ;
  SAin dst ;
} ;

typedef struct item *Item ;

struct iq {
  Seqno low, read, hi ;
  UL alen, nmsgs ;
  Item *arr ;
} ;


typedef struct iq *Iq ;

Iq iq ;

void nack(Seqno) ;

/***************************************************/

bool iq_empty(Iq) ;

void iq_print(Iq) ;

Item iq_create_pending(Iq, Seqno) ;

/***************************************************/

void iq_set_hi(Iq, Seqno) ;

void iq_set_low(Iq, Seqno) ;

/***************************************************/

Iq iq_create(size_t) ;

Iq *iq_array_create(size_t, size_t) ;

void iq_free(Iq) ;

void iq_array_free(Iq *, size_t) ;

/***************************************************/

void fast_read(Iq, Seqno, char *, size_t) ;

Item slow_read(Iq, Seqno, char *, size_t, bool *) ;

void iq_insert(Iq, Seqno, char *, size_t) ;

Item iq_get_item(Iq, Seqno) ;

#endif
