/* TODO: replace % with & if % is expensive */
#include "iq.h"

inline bool iq_empty(Iq iq) {
  return(iq->hi == iq->low) ;
}


static Seqno maxi(Iq iq) {
  return(iq->low + iq->alen) ;
}


static void set_data(Item p, char *msg, size_t size) {
  p->type = IQ_DATA ;
  p->msg = msg ;
  p->size = size ;
  p->first = p->last = Gettimeofday() ;
  p->local_cast_pending = false ;
  p->local_cast_timer = 0 ;
  return ;
}


/* TODO: verify that nlen is a power of 2 and growth is
 * at least 64.
 */
static void grow(Iq iq, UL nlen) {
  int oi, ni, i ;
  UL olen ;
  Item *oa, *na ;
  Seqno omax, nmax ;

  olen = iq->alen ;
  oa = iq->arr ;
  na = Calloc(nlen, sizeof(Item)) ;
  omax = maxi(iq) ;
  nmax = iq->low + nlen ;
  for (i = iq->low; i < omax; i++) {
    oi = i % olen ;
    ni = i % nlen ;
    na[ni] = oa[oi] ;
  }
  for (i = omax; i < nmax; i++) {
    ni = i % nlen ;
    na[ni] = Malloc(sizeof(struct item)) ;
  }
  free(iq->arr) ;
  iq->arr = na ;
  iq->alen = nlen ;

  if (iq_dbg) {
    printf("iq_size=%lu  nmsgs=%lu\n", iq->alen, iq->nmsgs) ;
  }

  return ;
}


Iq iq_create(size_t size) {
  Iq iq ;

  iq = Malloc(sizeof(struct iq)) ;
  iq->low = 0 ;
  iq->read = 0 ;
  iq->hi = 0 ;
  iq->arr = NULL ;
  iq->alen = 0 ;
  iq->nmsgs = 0 ;
  grow(iq, size) ;
  return(iq) ;
}


Iq *iq_array_create(size_t cnt, size_t size) {
  Iq *arr ;
  int i ;

  arr = Calloc(cnt, sizeof(Iq)) ;
  for (i = 0; i < cnt; i++) {
    arr[i] = iq_create(size) ;
  }
  return(arr) ;
}


static void overflow(Iq iq, Seqno hi) {
  size_t nlen ;

  while (hi >= maxi(iq)) {
    nlen = int_max(64, iq->alen * 2) ;
    grow(iq, nlen) ;
  }
  return ;
}


void iq_set_hi(Iq iq, Seqno hi) {
  if (hi >= maxi(iq)) {
    overflow(iq, hi) ;
  }
  if (hi > iq->hi) iq->hi = hi ;
  /*  iq->hi = int_max(iq->hi, hi) ;*/
  return ;
}


static void clear_item(Iq iq, Seqno seqno) {
  Item p ;
  UL index ;

  index = seqno % iq->alen ;
  p = iq->arr[index] ;
  free(p->msg) ;
  return ;
}


/* GC msgs in [iq->low, low) */
void iq_set_low(Iq iq, Seqno low) {
  Seqno seqno ;

  assert (low <= iq->hi) ;
  for (seqno = iq->low; seqno < low; seqno++) {
    iq->nmsgs-- ;
    clear_item(iq, seqno) ;
  }
  iq->low = low ;
  return ;
}


void iq_free(Iq iq) {
  iq_set_low(iq, iq->hi) ;
  return ;
}


void iq_array_free(Iq *arr, size_t cnt) {
  int i ;

  for (i = 0; i < cnt; i++) {
    iq_free(arr[i]) ;
  }
  free(arr) ;
  return ;
}


void iq_print(Iq iq) {
  /*
  Seqno seqno ;
  Item p ;
  */
  
  printf("Iq: low = %lu read = %lu hi = %lu max = %lu\n", iq->low, iq->read, iq->hi, maxi(iq)) ;
  printf("buf_size=%lu nmsgs=%lu\n", iq->alen, iq->nmsgs) ;
  /*
  printf("  [") ;

  for (seqno = iq->low; seqno < iq->hi; seqno++) {
    if ((p = iq_get(iq, seqno)) != NULL)
      printf("%d ", p->seqno) ;
  }
  printf("]\n") ;
  */
  return ;
}


void fast_read(Iq iq, Seqno seqno, char *msg, size_t size) {
  Seqno next ;
  UL index ;

  next = seqno + 1 ;
  iq->read = next ;
  iq_set_hi(iq, next) ;
  index = seqno % iq->alen ;
  set_data(iq->arr[index], msg, size) ;
  iq->nmsgs++ ;
  return ;
}


/* 
 * This function is called only if "seqno < iq->hi".
 * Otherwise "iq_insert" is called.
 */
Item slow_read(Iq iq, Seqno seqno, char *msg, size_t size, bool *duplicate) {
  UL index ;
  Item p ;

  if (seqno < iq->low) {
    free(msg) ;
    (*duplicate) = true ;
    return(NULL) ;
  }

  index = seqno % iq->alen ;
  p = iq->arr[index] ;
  switch (p->type) {
    case IQ_DATA:
      /* I already got the msg */
      free(msg) ;
      (*duplicate) = true ;
      return(NULL) ;

    case IQ_PENDING:
      if (p->local_try > 0) {
	timer_cancel(p->local_timer) ;
      }
      if (p->remote_try > 0) {
	timer_cancel(p->remote_timer) ;
      }
      p->local_try = p->remote_try = 0 ;

      p->type = IQ_DATA ;
      p->msg = msg ;
      p->size = size ;
      iq->nmsgs++ ;
      (*duplicate) = false ;
      return(p) ;
      
    case IQ_LOST:
      fprintf(stderr, "slow_read: recv msg %lu which was declared as lost\n", seqno) ;
      (*duplicate) = true ;
      return(NULL) ;

    default:
      fprintf(stderr, "Unknown type of Item in IQ") ;
      exit(1) ;
  }
}


/* 
 * This function is called only if "seqno >= iq->hi".
 * Otherwise "slow_read" is called.
 */
void iq_insert(Iq iq, Seqno seqno, char *msg, size_t size) {
  UL index ;

  iq_set_hi(iq, seqno+1) ;
  index = seqno % iq->alen ;
  set_data(iq->arr[index], msg, size) ;
  iq->nmsgs++ ;
  return ;
}


Item iq_get_item(Iq iq, Seqno seqno) {
  UL index ;

  if (seqno >= iq->low && seqno < iq->hi) {
    index = seqno % iq->alen ;
    return(iq->arr[index]) ;
  }
  return(NULL) ;
}
