#ifndef _INTLST_H
#define _INTLST_H

#include "util.h"

struct intlst_node {
  int key ;
  struct intlst_node *next ;
} ;

struct intlst {
  struct intlst_node *head, *tail ;
  int len ;
} ;

typedef struct intlst *IntLst ;

IntLst intlst_init(void) ;

void intlst_free(IntLst) ;

void intlst_append(IntLst, int) ;

bool intlst_empty(IntLst) ;

int intlst_pop(IntLst) ;

void intlst_print(char *, IntLst) ;

void intlst_print_file(IntLst, char *) ;

bool intlst_member(IntLst, int) ;

#endif
