#include "intlst.h"

typedef struct intlst_node Node ;

IntLst intlst_init(void) {
  IntLst l ;

  l = Malloc(sizeof(struct intlst)) ;
  l->head = l->tail = NULL ;
  l->len = 0 ;
  return(l) ;
}


Node *intlst_create(int i) {
  Node *p ;

  p = (Node *)Malloc(sizeof(Node)) ;
  p->key = i ;
  p->next = NULL ;
  return(p) ;
}


void intlst_free(IntLst l) {
  Node *p ;

  p = l->head ;
  while (p != NULL) {
    l->head = l->head->next ;
    free(p) ;
    p = l->head ;
  }
  free(l) ;
  return ;
}


void intlst_append(IntLst l, int i) {
  Node *p ;

  p = intlst_create(i) ;
  if (l->tail == NULL) {
    l->head = l->tail = p ;
  } else {
    l->tail->next = p ;
    l->tail = p ;
  }
  l->len++ ;
  return ;
}


void intlst_print(char *prefix, IntLst l) {
  Node *p ;

  printf("%s: [", prefix) ;
  p = l->head ;
  while (p != NULL) {
    printf("%d", p->key) ;
    p = p->next ;
    if (p != NULL) printf(" ") ;
  }
  printf("]\n") ;
}


void intlst_print_file(IntLst l, char *fname) {
  FILE *fp ;
  Node *p ;

  fp = Fopen(fname, "w") ;
  p = l->head ;
  while (p != NULL) {
    fprintf(fp, "%d\n", p->key) ;
    p = p->next ;
  }
  fclose(fp) ;
  return ;
}


bool intlst_member(IntLst l, int i) {
  Node *p ;

  p = l->head ;
  while (p != NULL) {
    if (p->key == i) return(true) ;
    p = p->next ;
  }
  return(false) ;
}


bool intlst_empty(IntLst l) {
  return(l->head == NULL) ;
}


int intlst_pop(IntLst l) {
  Node *p ;
  int key ;

  p = l->head ;
  if (p == NULL) {
    printf("Error[intlst_pop]: empty list\n") ;
    exit(1) ;
  }
  l->head = l->head->next ;
  l->len-- ;
  key = p->key ;
  free(p) ;
  return(key) ;
}
