#include "emulate.h"
#include "net.h"
#include "appl.h"
#include "view.h"
#include "timer.h"
#include "marshal.h"
#include "param.h"

static bool enabled = true ;
static double DELAY = 0.01 ;

static char **lr ;
static size_t lsize ;


bool local_host(char *hostname) {
  size_t i ;

  for (i=0; i<lsize; i++) {
    if (!strcmp(hostname, lr[i])) {
      return(true) ;
    }
  }
  return(false) ;
}


void emulate_init(void) {
  StrLst l1, l2 ;
  char **r1, **r2 ;
  size_t n1, n2 ;
  size_t i ;

  enabled = param_bool("emulate_enabled") ;
  DELAY = param_double("emulate_delay") ;
  printf("DELAY message for %.3fms\n", DELAY * 1000) ;
  l1 = file2strlst("region1") ;
  l2 = file2strlst("region2") ;
  r1 = strlst2array(l1, &n1) ;
  r2 = strlst2array(l2, &n2) ;
  
  for (i=0; i<n1; i++) {
    if (!strcmp(myname, r1[i])) {
      lr = r1 ;
      lsize = n1 ;
      return ;
    }
  }
  for (i=0; i<n2; i++) {
    if (!strcmp(myname, r2[i])) {
      lr = r2 ;
      lsize = n2 ;
      return ;
    }
  }
}


bool emulate_delay(SAin fromaddr, char *buf, size_t size) {
  Type type ;
  size_t offset ;
  char *msg ;

  if (!enabled) return(false) ;
  offset = 0 ;
  type = type_um(buf, &offset) ;
  if (type == STOP) return(false) ;
  if (local_member(fromaddr)) {
    return(false) ;
  }
  msg = Malloc(size) ;
  memcpy(msg, buf, size) ;
  timer_msg("emulate", DELAY, appl_proc_msg, msg, size) ;
  return(true) ;
}

#define LOCAL_CAST      16
#define LOCAL_SESS      21

bool emulate_drop_cast(SAin fromaddr, char *buf, size_t size) {
  Type proto, type ;
  char *hostname ;
  size_t offset ;

  if (!enabled) return(false) ;
  offset = 0 ;
  proto = type_um(buf, &offset) ;
  if (proto == RRMP) {
    type = type_um(buf, &offset) ;
    if (type == LOCAL_CAST) {
      if (!local_member(fromaddr)) {
	return(true) ;
      }
    }
  } else if (proto == SESS) {
    type = type_um(buf, &offset) ;
    hostname = str_um(buf, &offset) ;
    if (type == LOCAL_SESS || type == LOCAL_CAST) {
      if (!local_host(hostname)) {
	return(true) ;
      }
    }
  }
  return(false) ;
}
