#include "dtime.h"

struct node {
  Seqno seqno ;
  TV t ;
  struct node *next ;
} ;

typedef struct node Node ;

static Node *head = NULL ;


void dtime_set(Seqno seqno, TV t) {
  Node *p ;

  p = Malloc(sizeof(Node)) ;
  p->seqno = seqno ;
  p->t = t ;
  p->next = head ;
  head = p ;
  return ;
}


bool dtime_exist(Seqno seqno) {
  Node *p ;

  p = head ;
  while (p != NULL) {
    if (p->seqno == seqno) {
      return(true) ;
    }
    p = p->next ;
  }
  return(false) ;
}


TV dtime_get(Seqno seqno) {
  Node *p, *pre ;
  TV t ;

  p = head ;
  pre = NULL ;
  while (p != NULL) {
    if (p->seqno == seqno) {
      t = p->t ;
      if (pre != NULL) {
	pre->next = p->next ;
      } else {
	head = p->next ;
      }
      free(p) ;
      return(t) ;
    }
    pre = p ;
    p = p->next ;
  }
  printf("Error[dtime]: entry not found\n") ;
  exit(1) ;
}
