#include "proto.h"

#define RANDOM 1
#define BURST  2
#define SINGLE 3

static int method = RANDOM ;

static struct state {
  bool enabled ;
  double drop_rate ;
  bool first_burst ;
  Seqno burst_len, interval, last_seqno, single ;
} s ;


void drop_init(void) {
  method = param_int("drop_method") ;
  s.enabled = param_bool("drop_enabled") ;
  s.drop_rate = param_double("drop_rate") ;
  s.burst_len = param_int("burst_len") ;
  s.interval = param_int("interval") ;
  s.last_seqno = param_int("last_seqno") ;
  /*  s.last_seqno = rand_int(100) + 10 ;*/
  if (s.enabled && method == BURST) printf("starting drop at: %lu\n", s.last_seqno) ;
  if (method == RANDOM) printf("random drop at rate: %.3f\n", s.drop_rate) ;
  s.first_burst = false ;
  s.single = 4 ;
  assert (s.burst_len * 2 < s.interval) ;
  return ;
}


static bool random_loss(Seqno seqno) {
  /* don't drop the first msg */
  if (seqno == 0) return(false) ;
  return (rand_frac() < s.drop_rate) ;
}


static bool single_loss(Seqno seqno) {
  if (seqno == s.single) {
    return(true) ;
  }
  return(false) ;
}


static bool burst_loss(Seqno seqno) {
  /* start the first burst? */
  if (!s.first_burst) {
    if (seqno >= s.last_seqno) {
      s.last_seqno = seqno ;
      s.first_burst = true ;
      return(true) ;
    } else {
      return (false) ;
    }
  }

  /* start a new burst? */
  if (seqno > s.interval + s.last_seqno) {
    s.last_seqno = seqno ;
    return(true) ;
  }

  /* still in the burst? */
  if (seqno < s.burst_len + s.last_seqno) {
    return(true) ;
  }

  return(false) ;
}


bool drop_recv(Type proto, Type type, Seqno seqno) {
  if (!s.enabled) return(false) ;
  switch (method) {
    case RANDOM:
      return(random_loss(seqno)) ;

    case BURST:
      return(burst_loss(seqno)) ;

    case SINGLE:
      return(single_loss(seqno)) ;
  }
}

