#include "cnt.h"

struct node {
  Type type ;
  Seqno seqno ;
  UL counter ;
  SAin target ;
  struct node *next ;
} ;

typedef struct node Node ;

static Node *head = NULL ;


UL cnt_get(Type type, Seqno seqno, SAin *target) {
  Node *p ;

  p = head ;
  while (p != NULL) {
    if (p->type == type && p->seqno == seqno) {
      (*target) = p->target ;
      return(p->counter) ;
    }
    p = p->next ;
  }
  return(0) ;
}


UL cnt_incr(Type type, Seqno seqno, SAin target) {
  Node *p ;

  p = head ;
  while (p != NULL) {
    if (p->type == type && p->seqno == seqno) {
      return(++p->counter) ;
    }
    p = p->next ;
  }
  p = Malloc(sizeof(Node)) ;
  p->type = type ;
  p->seqno = seqno ;
  p->counter = 1 ;
  p->target = target ;
  p->next = head ;
  head = p ;
  return(1) ;
}


void cnt_del(Type type, Seqno seqno) {
  Node *p, *pre ;

  p = head ;
  pre = NULL ;
  while (p != NULL) {
    if (p->type == type && p->seqno == seqno) {
      if (pre != NULL) {
	pre->next = p->next ;
      } else {
	head = p->next ;
      }
      free(p) ;
      return ;
    }
    pre = p ;
    p = p->next ;
  }
  printf("Error[cnt]: entry not found.  type=%u seqno=%lu\n", type, seqno) ;
  exit(1) ;
}
