#include "proto.h"

#define MAXBUFLEN 20480


void appl_proc_msg(char *buf, size_t size) {
  size_t offset ;
  Type type ;

  offset = 0 ;
  type = type_um(buf, &offset) ;
  switch (type) {
    case RRMP:
      rrmp_recv(buf, offset, size) ;
      break ;

    case SESS:
      sess_recv(buf, offset) ;
      break ;

    case STOP:
      rrmp_final() ;
      sess_final() ;
      exit(0) ;

    default:
      printf("Error[APPL]: Unknown msg type\n") ;
      exit(1) ;
  }
}


static void poll_msg(int sock) {
  char buf[MAXBUFLEN] ;
  size_t size ;
  SAin fromaddr ;
  int addrlen ;

  addrlen = sizeof(fromaddr) ;
  size = Recvfrom(sock, buf, MAXBUFLEN, &fromaddr, &addrlen) ;
  if (sock == cast_recv_sock) {
    if (emulate_drop_cast(fromaddr, buf, size)) return ;
  }
  if (addr_ip_eq(fromaddr, myaddr)) return ;
  if (!emulate_delay(fromaddr, buf, size)) {
    appl_proc_msg(buf, size) ;
  }
  return ;
}


void appl_stop(void) {
  char buf[1024] ;
  size_t offset ;

  offset = 0 ;
  type_ms(buf, &offset, STOP) ;
  Sendto(cast_xmit_sock, buf, offset, &grpaddr) ;
  rrmp_final() ;
  sess_final() ;
  Sendto(cast_xmit_sock, buf, offset, &grpaddr) ;
  Sendto(cast_xmit_sock, buf, offset, &grpaddr) ;
  Sendto(cast_xmit_sock, buf, offset, &grpaddr) ;
  Sendto(cast_xmit_sock, buf, offset, &grpaddr) ;
  Sendto(cast_xmit_sock, buf, offset, &grpaddr) ;
  exit(0) ;
}


static void check_stop_file(void) {
  timer_sweep("appl", 5.0, check_stop_file) ;
  if (check_stop()) {
    printf("STOP file exists\n") ;
    exit(0) ;
  }
}


static void proc_stdin(void) {
  char buf[MAXBUFLEN] ;

  Fgets(buf, MAXBUFLEN, stdin) ;
  if (!strcmp(buf, "stop")) {
    appl_stop() ;
  }
  if (appl_recv_stdin != NULL) {
    appl_recv_stdin(buf) ;
  }
  return ;
}


void appl_init(int argc, char **argv) {
  char *ipaddr ;

  start_time = Gettimeofday() ;
  rand_init() ;
  if (check_stop()) {
    fprintf(stderr, "Warning: stop file exists\n") ;
  }
  param_init(argc, argv) ;

  pt2pt_port = param_int("pt2pt_port") ;
  cast_port = param_int("cast_port") ;
  pt2pt_xmit_sock = socket_dgram() ;
  pt2pt_recv_sock = socket_dgram_and_bind(pt2pt_port) ;
  cast_xmit_sock = socket_dgram_and_bind(0) ;
  myaddr = getmyaddr(get_sock_port(cast_xmit_sock)) ;
  /* ignore domain name "cs.cornell.edu" */
  Gethostname2(myname, MAXHNAMELEN) ;
  ipaddr = param_str("ipaddr") ;
  grpaddr = getaddrbyip(ipaddr, cast_port) ;
  addr_print("IPMC address", grpaddr) ;

  cast_recv_sock = socket_dgram() ;
  join_group(cast_recv_sock, grpaddr) ;
  Bind(cast_recv_sock, &grpaddr) ;

  /* "myname" and "myaddr" are needed below */
  view_init() ;
  rrmp_init() ;
  drop_init() ;
  sess_init() ;
  emulate_init() ;
  timer_sweep("appl", 5.0, check_stop_file) ;

  appl_recv_cast = NULL ;
  appl_recv_stdin = NULL ;
  appl_recv_hbt = NULL ;
  appl_recv_view = NULL ;
  appl_start = NULL ;
  appl_final = NULL ;
  appl_hbt_rate = 0.0 ;
  return ;
}


static void recv_hbt(void) {
  assert (appl_recv_hbt != NULL) ;
  timer_sweep("appl", appl_hbt_rate, recv_hbt) ;
  appl_recv_hbt() ;
  return ;
}


void appl_start_hbt(void) {
  assert (appl_hbt_rate > 0.0) ;
  timer_sweep("appl", appl_hbt_rate, recv_hbt) ;
  return ;
}


void appl_main_loop(void) {
  fd_set rset ;
  int maxfdp1 ;
  TV t, *timeout ;

  if (appl_recv_hbt != NULL) appl_start_hbt() ;
  FD_ZERO(&rset) ;
  for ( ; ; ) {
    FD_SET(cast_recv_sock, &rset) ;
    FD_SET(pt2pt_recv_sock, &rset) ;
    FD_SET(0, &rset) ;

    t = timer_run() ;
    if (time_is_invalid(t)) {
      timeout = NULL ;
    } else {
      timeout = &t ;
    }

    maxfdp1 = int_max(cast_recv_sock, pt2pt_recv_sock) + 1 ;
    select(maxfdp1, &rset, NULL, NULL, timeout) ;

    if (FD_ISSET(cast_recv_sock, &rset)) {
      poll_msg(cast_recv_sock) ;
    }

    if (FD_ISSET(pt2pt_recv_sock, &rset)) {
      poll_msg(pt2pt_recv_sock) ;
    }

    if (FD_ISSET(0, &rset)) {
      proc_stdin() ;
    }
  }
}


void appl_cast(char *appl_msg, size_t size) {
  char *msg ;

  msg = Malloc(size) ;
  memcpy(msg, appl_msg, size) ;
  rrmp_cast(msg, size) ;
  return ;
}


void appl_deliver(char *msg, size_t size) {
  if (appl_recv_cast != NULL) {
    appl_recv_cast(msg, size, sender) ;
  }
  return ;
}


void appl_report_lost(void) {
  /* add appropriate handling here */
  return ;
}
