// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

import java.rmi.*;
import java.io.*;
import ninja.rmi.NinjaRemoteObject;

public class TheServiceImpl extends NinjaRemoteObject implements TheService {

  public TheServiceImpl() throws RemoteException {
    super(null);

    // For unreliable connections, we have to specify the comm_type as
    // RMI_COMM_TYPE_UNRELIABLE_ONEWAY.

    ninja.rmi.NinjaExportData data = new ninja.rmi.NinjaExportData();
    data.comm_type = ninja.rmi.NinjaExportData.RMI_COMM_TYPE_UNRELIABLE_ONEWAY;
    this.exportObject(data);
    System.out.println("This is the serviceclass constructor method being called\n");
  }

  public void someFunction() throws RemoteException {
    Thread thread = Thread.currentThread();
    String clientpeer;

    // This is a demonstration of how to determine the name of the client
    // machine doing the RMI. We take the current thread and cast it to
    // a ninja.rmi.UnrelOw_ServerThread (which it should be), and query that.

    try {
      Thread t = Thread.currentThread();
      if (t instanceof ninja.rmi.UnrelOw_ServerThread) {
        clientpeer = ((ninja.rmi.UnrelOw_ServerThread)t).getClientHost();
      } else {
	throw new RemoteException("Must use Reliable transport");
      }
      System.out.println("TheServiceImpl called from "+clientpeer);
    } catch (Exception e) {
      throw new RemoteException(e.getMessage());
    }
  }
  
}

