// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

import java.rmi.*;
import java.io.*;
import ninja.rmi.NinjaRemoteObject;

public class TheServiceImpl extends NinjaRemoteObject implements TheService {

  public TheServiceImpl() throws RemoteException {
    super(null);

    // For multicast RMI objects, we have to set the comm_type to 
    // RMI_COMM_TYPE_MULTICAST_ONEWAY, and specify the multicast IP address
    // ("multicast group") to listen on.

    ninja.rmi.NinjaExportData data = new ninja.rmi.NinjaExportData();
    data.comm_type = ninja.rmi.NinjaExportData.RMI_COMM_TYPE_MULTICAST_ONEWAY;
    try {
      data.ipaddr = java.net.InetAddress.getByName("224.0.0.1");
    } catch (Exception e) {
      throw new RemoteException("Can't lookup host", e);
    }
    // We set the port ID to listen on so all instances of the service
    // will listen on the same port.
    data.port = 4242;
    // Also, we want to ignore the 'object id' which is transmitted to the
    // server from the client - this is because there's no easy way to
    // ensure that the object id's on all servers are the same. The
    // registry could be enhanced to deal with this...
    data.check_objid = false; 
    
    this.exportObject(data);
    System.out.println("This is the serviceclass constructor method being called\n");
  }

  public void someFunction() throws RemoteException {
    Thread thread = Thread.currentThread();
    String clientpeer;

    // To find out what the client is, we cast the current thread to
    // McastOw_ServerThread (which it should be), and query that.

    try {
      Thread t = Thread.currentThread();
      if (t instanceof ninja.rmi.McastOw_ServerThread) {
        clientpeer = ((ninja.rmi.McastOw_ServerThread)t).getClientHost();
      } else {
	throw new RemoteException("Must use Reliable transport");
      }
      System.out.println("TheServiceImpl called from "+clientpeer);
    } catch (Exception e) {
      throw new RemoteException(e.getMessage());
    }
  }
  
}

