// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.util.Properties;
import ninja.rmi.*;
import ninja.rmi.registry.*;

class RmiServer {
  public static void main(String args[]) {
    
    TheServiceImpl service;
    NinjaRemoteRef ninjaremoteref;
    Registry reg;
    int i;

    try {
      String hostname = "asbestos";

      System.out.println("RMISERVER: Connecting to registry on "+hostname+":1099...");
      reg = (Registry)NinjaLocateRegistry.getRegistry(hostname, 1099);
      System.out.println("RMISERVER: Got registry");
      
      service = new TheServiceImpl();
      System.out.println("RMISERVER: Created service\n");

	  reg.rebind("service", service);
      System.out.println("RMISERVER: Bound service");
      
    } catch (Exception e) {
      System.out.println("RmiServer error: " +e.getMessage());
      e.printStackTrace();
    }
  }
}


