// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */

import java.rmi.*;
import java.util.*;
import java.io.*;
import java.rmi.server.*;
import java.rmi.registry.*;

import ninja.rmi.*;
import ninja.rmi.registry.*;

class RmiClient {
  public static void main(String args[]) {
    
    int NUM_TIMES=10000;
    TheService service;
    NinjaRemoteRef ninjaremoteref;
    Registry reg;

    try {
      String hostname = "asbestos";

      System.out.println("Connecting to registry on "+hostname+":1099...");
      reg = (Registry)NinjaLocateRegistry.getRegistry(hostname, 1099);

      System.out.println("Got registry stub");
	  
	  long t1, t2;
      int i;
      t1 = System.currentTimeMillis();
      
      service = (TheService)reg.lookup("service");
	  NinjaRemoteRef ref = ((NinjaRemoteStub)service).getNinjaRemoteRef();
      
      System.out.println("Got service, server is "+ref.get_remotehost()+":"+ref.get_remoteport());
     
      for (i = 0; i < NUM_TIMES; i++) {
	service.someFunction();
      }
      t2 = System.currentTimeMillis();

      System.out.println(NUM_TIMES + " RMIs in " + (t2-t1) + "ms, or " +
			 ((t2-t1)/(NUM_TIMES*1.0)) + " ms/RMI.");
      

    } catch (Exception e) {
      System.out.println("RmiClient exception: " + e.getMessage());
      e.printStackTrace();
    }
  }
}
