// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */





package ninja.rmi;

import java.rmi.*;
import java.rmi.server.*;
import java.net.ServerSocket;
import java.net.Socket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.DatagramSocket;
import java.net.DatagramPacket;

/**
 * An UnrelOw_ServerThread implements a NinjaServerThread which accepts
 * unreliable, incoming only calls on a UDP socket. The server is not allowed
 * to throw an exception or return any arguments to the call.
 */
public class UnrelOw_ServerThread extends NinjaServerThread {
  private DatagramSocket serverSocket;
  private int port;
  private boolean active_call;
  private String curr_client_host;
  private int curr_client_port;

  UnrelOw_ServerThread(NinjaServerRef serverref, int theport) throws Exception {
    super(serverref);
    if (theport != 0) {
      serverSocket = new DatagramSocket(theport);
    } else {
      serverSocket = new DatagramSocket();
    }
    port = serverSocket.getLocalPort();
    active_call = false;
  }

  /**
   * Returns the hostname of the client making the RMI call in this thread.
   */
  public String getClientHost() throws ServerNotActiveException {
    if (active_call == false) throw new ServerNotActiveException("Thread has no active client connection");
    return curr_client_host;
  }
  
  /**
   * Returns the remote port number of the client making the RMI call in 
   * this thread.
   */
  public int getClientPort() throws ServerNotActiveException {
    if (active_call == false) throw new ServerNotActiveException("Thread has no active client connection");
    return curr_client_port;
  }

  /**
   * Returns the port on which the server is listening for new calls.
   */
  public int getServerPort() throws ServerNotActiveException {
    if (serverSocket == null) throw new ServerNotActiveException("Thread has no active server socket");
    return port;
  }


  // Listen on serverSocket for connections
  public void run() {
     ;

    DatagramPacket dp = new DatagramPacket(new byte[64*1024], 64*1024);

  next_packet:
    while (true == true) {
      active_call = false;

      try {
	serverSocket.receive(dp);
      } catch (Exception e) {
	System.out.println("NinjaServerThread["+port+"]: Can't do receive on UDP socket");
	return;
      }

      BufferedInputStream bis;
      BufferedOutputStream bos;
      DataInputStream datais;
      DataOutputStream dataos;
      int i;
      short s;
      byte b;
      
      try {
	bis = new BufferedInputStream(new ByteArrayInputStream(dp.getData()));
	datais = new DataInputStream(bis);
	i = datais.readInt();
	s = datais.readShort();
	
      } catch (Exception e) {
	 ;
	continue next_packet;
      }
      
      if (i != 0x4e524d49 || s != 0x02) {
	 ;
	continue next_packet;
      }

      curr_client_host = dp.getAddress().getHostName();
      curr_client_port = dp.getPort();
      active_call = true;
      
       ;

      try {
	b = datais.readByte();
      } catch (Exception e) {
	 ;
	continue next_packet;
      }
	
      msg_switch: {
	switch (b) {
	case 0x50: // Call
	   ;
	  
	  NinjaRemoteCall call = new UnrelOw_RemoteCall(bis);
	  ObjectInput callis;
	  ObjID theobj;
	  
	  try {
	    callis = call.getInputStream();
	     ;
	    theobj = ObjID.read(callis);
	     ;
	  } catch (IOException e) {
	     ;
	    continue next_packet;
	  }
	  
	  if (!servref.objid.equals(theobj)) {
	    // Do we care if the ObjID doesn't match?
	    if (servref.exportData.check_objid == true) {
	      System.out.println("NinjaServerThread["+port+"]: ObjID doesn't match");
	      continue next_packet;
	    }
	  }
	  
	  int op;
	  long hash;
	  
	  try {
	    op = callis.readInt();
	    hash = callis.readLong();
	  } catch (IOException e) {
	     ;
	    continue next_packet;
	  }
	  
	   ;
	  try {
	    servref.skeleton.dispatch(servref.remote, call, op, hash);
	  } catch(Exception e) {
	     ;
	    e.printStackTrace();

	  }
	    
	  break;
	    
	  default:
	     ;
	    continue next_packet;
	    
	}
      }
    }
  }
  
}
