// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */





package ninja.rmi;

import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteCall;
import java.rmi.RemoteException;
import java.rmi.Remote;
import java.rmi.server.Operation;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.IOException;
import java.lang.ClassNotFoundException;
import java.rmi.server.ObjID;
import java.rmi.server.UID;
import java.net.Socket;
import java.io.StreamCorruptedException;
import java.io.OutputStream;
import java.io.InputStream;
import java.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.MalformedURLException;

// A RemoteCall that deals with an unreliable, one-way UDP connection
class UnrelOw_RemoteCall implements NinjaRemoteCall {
  NinjaObjectOutputStream objout;
  NinjaObjectInputStream objin;
  InputStream is;
  OutputStream os;
  boolean is_server;

  // This is the client-side constructor 
  UnrelOw_RemoteCall(OutputStream theos, ObjID objid, int i, long j) throws IOException {
    is_server = false;
    os = theos;

    // Write call header
    DataOutputStream dataos = new DataOutputStream(os);
    dataos.writeByte(0x50);

    objout = new NinjaObjectOutputStream(dataos);
    objid.write(objout);
    objout.writeInt(i);
    objout.writeLong(j);
    //objout.flush();
  }

  // This is the server-side constructor
  UnrelOw_RemoteCall(InputStream theis) {
    is_server = true;
    is = theis; 
  }

  public ObjectOutput getOutputStream() throws IOException {
    if (is_server) throw new IOException("NinjaRemoteCallUnreliableOneway: Server side cannot send output!");
    
    if (objout == null) {
      objout = new NinjaObjectOutputStream(new DataOutputStream(os));
    }
    return objout;
  }

  public void releaseOutputStream() throws IOException {
    if (is_server) throw new IOException("NinjaRemoteCallUnreliableOneway: Server side cannot send output!");
    
     ;
    objout.flush(); // XXX need to close?
  }

  public ObjectInput getInputStream() throws IOException {
    if (!is_server) throw new IOException("NinjaRemoteCallUnreliableOneway: Client side cannot read input!");
    
    if (objin == null) {
      objin = new NinjaObjectInputStream(new DataInputStream(is));
    }
    return objin;
  }

  public void releaseInputStream() throws IOException {
    if (!is_server) throw new IOException("NinjaRemoteCallUnreliableOneway: Client side cannot read input!");
    
  }

  public ObjectOutput getResultStream(boolean flag)
    throws IOException, StreamCorruptedException {
    // XXX mdw! Shouldn't get used, but the skel uses it anyway...
    return null;
    //if (!is_server) throw new IOException("NinjaRemoteCallUnreliableOneway: Server side cannot write result!");

    /*
    DataOutputStream dataos = new DataOutputStream(os);
    dataos.writeByte(0x51);

    getOutputStream();
    if (flag) {
      objout.writeByte(1); // Success
    } else {
      objout.writeByte(2); // Failure
    }
    // Write ID
    UID resultid = new UID();
    resultid.write(objout);
    //objout.flush();
    return objout;
    */
  }

  public void executeCall() throws Exception {
    objout.flush(); // Flush output
  }

  public void done() throws IOException {
  }
  
}
  
