// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */





package ninja.rmi;

import java.util.Hashtable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.*;
import java.net.*;
import java.io.IOException;
import java.lang.reflect.Constructor;


// The server-side handle for a remote object
class NinjaServerRef {
  ObjID objid;
  Remote remote;
  NinjaSkeleton skeleton;
  NinjaRemoteStub stub;
  NinjaServerThread serverThread;
  NinjaRemoteRef clientRef;
  NinjaExportData exportData = null;

  NinjaServerRef() { }

  NinjaRemoteStub exportObject(Remote theremote, NinjaExportData data) throws RemoteException {
    
    Class theclass;
    String skelname, stubname;

     ;

    if (data == null) throw new RemoteException("exportObject: Can't export object will null exportData!");
      
    exportData = data;

    remote = theremote;
    objid = new ObjID();

    // Get skeleton from class
    
    try {
      theclass = getRemoteClass(remote);
      skelname = new StringBuffer(String.valueOf(theclass.getName())).append("__RMISkel").toString();
    } catch (ClassNotFoundException e) {
      throw new RemoteException(new StringBuffer("Can't find skeleton for object: ").append(remote.getClass().getName()).toString());
    }

    try {
       ;
      Class skelclass = loadClassUsingLoader(skelname, theclass);
       ;
      skeleton = (NinjaSkeleton)skelclass.newInstance();

       ;
      
    } catch (Exception e) {
      throw new RemoteException(new StringBuffer("Can't create skeleton for object: ").append(remote.getClass().getName()).toString() + e);
    }

    // Now, before we can get the stub we need to create the NinjaServerThread
    // to listen for this object, so we can initialize the client-side
    // NinjaRemoteRef which will point back to this object when it's pushed
    // to the client. This is because we need to call the stub's constructor
    // with the NinjaRemoteRef as an argument to get it set in the stub
    // (as the other ways to set the remoteRef later are protected methods
    // of RemoteStub).

//    XXX mdw: The below code uses the RMISocketFactory; I've axed it for now
//
//    RMISocketFactory factory = RMISocketFactory.getSocketFactory();
//    // XXX mdw Don't like having to use Sun's stuff.
//    if (factory == null) factory = new sun.rmi.transport.proxy.RMIMasterSocketFactory();
//    ServerSocket serverSock = factory.createServerSocket(exportData.port);

     ;

    if (exportData.comm_type == NinjaExportData.RMI_COMM_TYPE_RELIABLE) {

      try {
	serverThread = new Reliable_ServerThread(this, exportData.port);
	int port = ((Reliable_ServerThread)serverThread).getServerPort();
	clientRef = new NinjaRemoteRef(InetAddress.getLocalHost().getHostName(), port, objid, exportData.comm_type, exportData.service_name);  // -- Zhongwei
      } catch (Exception e) {
	throw new RemoteException("Can't create Reliable_ServerThread: " + e.getMessage(), e);
      }

    } else if (exportData.comm_type == NinjaExportData.RMI_COMM_TYPE_UNRELIABLE_ONEWAY) {

      try {
	serverThread = new UnrelOw_ServerThread(this, exportData.port);
	int port = ((UnrelOw_ServerThread)serverThread).getServerPort();
	clientRef = new NinjaRemoteRef(InetAddress.getLocalHost().getHostName(), port, objid, exportData.comm_type, exportData.service_name ); // add a new feature, "remote ref name"  -- Zhongwei 
      } catch (Exception e) {
	throw new RemoteException("Can't create UnrelOw_ServerThread: "+e.getMessage(), e);
      }

    } else if (exportData.comm_type == NinjaExportData.RMI_COMM_TYPE_MULTICAST_ONEWAY) {

      try {
	serverThread = new McastOw_ServerThread(this, exportData.ipaddr, exportData.port);
	int port = ((McastOw_ServerThread)serverThread).getServerPort();
	clientRef = new NinjaRemoteRef(exportData.ipaddr.getHostAddress(),
				       port, objid, exportData.comm_type, exportData.service_name ); // add a new feature, "remote ref name"  -- Zhongwei
      } catch (Exception e) {
	throw new RemoteException("Can't create McastOw_ServerThread: "+e.getMessage(), e);
      }

	} else {

      throw new RemoteException("NinjaServerRef: Invalid comm_type "+exportData.comm_type);

    }

    // Get stub from class
    stubname = new StringBuffer(String.valueOf(theclass.getName())).append("__RMIStub").toString();

    // Now find the one-arg 'RemoteRef' constructor for this object
    
    try {
      int c, p;
      boolean found_constructor = false;
      Class stubclass = loadClassUsingLoader(stubname, theclass);
      Constructor constarr[] = stubclass.getConstructors();
      for (c = 0; (c < constarr.length) && !found_constructor; c++) {
	Class paramarr[] = constarr[c].getParameterTypes();
	 ;
	if ((paramarr.length == 1) &&
	    (paramarr[0].getName().equals("ninja.rmi.NinjaRemoteRef"))) {
	   ;
	  Object inargs[] = new Object[1];
	  inargs[0] = (ninja.rmi.NinjaRemoteRef)clientRef;
	  stub = (NinjaRemoteStub)constarr[c].newInstance(inargs);
	  found_constructor = true;
	}
      }
      if (!found_constructor) {
	throw new RemoteException(new StringBuffer("Can't create stub for object (no NinjaRemoteRef constructor??): ").append(remote.getClass().getName()).toString());
      }
      
       ;
      
    } catch (Exception e) {
      throw new RemoteException(new StringBuffer("Can't create stub for object: ").append(remote.getClass().getName()).toString(), e);
    }

    serverThread.start();

    return stub;
    
  }

  void unexportObject() {
    serverThread.stop();
  }    

  NinjaRemoteStub getStub() {
    return stub;
  }
  
  // Loads a class using the named 'theclass' ClassLoader (in case this
  // is being passed along using an RMIClassLoader)
  private Class loadClassUsingLoader(String string, Class theclass) throws ClassNotFoundException {
    ClassLoader classLoader = null;
    if (theclass != null) classLoader = theclass.getClassLoader();
    if (classLoader != null) {
      return classLoader.loadClass(string);
    } else {
      return Class.forName(string);
    }
  }
  
  // Traverse superclasses until we get the one which extends Remote
  private Class getRemoteClass(Remote theremote) throws ClassNotFoundException {
    Class theclass;
    for (theclass = theremote.getClass(); theclass != null; theclass = theclass.getSuperclass()) {
      if (classExtendsRemote(theclass)) return theclass;
    }
    throw new ClassNotFoundException("java.rmi.Remote");
  }

  // Recursively check all interfaces for this class to see if they
  // extend java.rmi.Remote
  private boolean classExtendsRemote(Class theclass) throws ClassNotFoundException {
    Class remClass = Class.forName("java.rmi.Remote");
    Class interfaces[] = theclass.getInterfaces();
    int i;
    for (i = 0; i < interfaces.length; i++) {
      if (interfaces[i].equals(remClass)) return true;
      if (classExtendsRemote(interfaces[i])) return true;
    }
    return false;
  }

}

