// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */





package ninja.rmi;

/**
 * NinjaServerCallbacks is an interface that the user of NinjaRMI can
 * implement to get callbacks on certain events of the server side of
 * an RMI connection. The idea is that one creates an implementation of
 * NinjaServerCallbacks and places it in the NinjaExportData structure
 * when exporting a NinjaRemoteObject. When certain events occur (such
 * as socket creation and destruction), the callback on that object will
 * be invoked.
 *
 * @see NinjaExportData
 * @see NinjaRemoteObject
 */
public interface NinjaServerCallbacks {

  /**
   * Called when a client socket to the RMI server object is created.
   * @param hostname The hostname of the connecting client.
   * @param localport The remote port of the socket.
   */
  public void socket_created(String hostname, int port);

  /**
   * Called when a client socket to the RMI server object is destroyed.
   * @param hostname The hostname of the destroyed socket.
   * @param localport The remote port of the socket.
   */
  public void socket_destroyed(String hostname, int port);
  
}
