// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */





package ninja.rmi;

import java.rmi.UnmarshalException;


/**
 * NinjaRemoteStub is the superclass of client-side 'stub' objects.
 */
public class NinjaRemoteStub implements java.io.Serializable {

  // The remote ref associated with this stub
  protected NinjaRemoteRef _ref;

  protected NinjaRemoteStub(NinjaRemoteRef ref) {
    _ref = ref;
  }
  
  /**
   * Returns the NinjaRemoteRef contained within the Stub.
   * Made public so that client-side code can access the ref.
   */
  public NinjaRemoteRef getNinjaRemoteRef() {
    return _ref;
  }

  /**
   * Used by object serialization
   */
  private void writeObject(java.io.ObjectOutputStream out)
    throws java.io.IOException, java.lang.ClassNotFoundException {
    if (_ref == null) {
      throw new java.rmi.MarshalException("Invalid stub - _ref is null");
    } else {
      out.writeUTF(_ref.getRefClass(out));
      _ref.writeExternal(out);
    }
  }

  /**
   * Used by object serialization
   */
  private void readObject(java.io.ObjectInputStream in)
    throws java.io.IOException, java.lang.ClassNotFoundException {
    try {
      Class refClass = Class.forName(in.readUTF());
      _ref = (NinjaRemoteRef)refClass.newInstance();
      _ref.readExternal(in);
    } catch (InstantiationException e) {
      throw new UnmarshalException("Unable to instantiate remote reference", e);
    } catch (IllegalAccessException e) {
      throw new UnmarshalException("Illegal access creating remote reference", e);
    }
  }
  
}
