// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */





package ninja.rmi;

import java.io.*;
import java.net.*;

// An OutputStream which replaces subclasses of java.rmi.Remote with their
// stubs during serialization - to be used on the server side of an RMI
// connection
class NinjaObjectOutputStream extends ObjectOutputStream {

  public NinjaObjectOutputStream(OutputStream os) throws IOException {
    super(os);
    try {
      enableReplaceObject(true);
    } catch (SecurityException e) {
      // XXX mdw: It looks like ObjectOutputStream doesn't let us 
      // enable object replacement if the NinjaObjectOutputStream has 
      // a non-null classloader (as it will for applets; what about 
      // other clients w/o access to the ninja.rmi package?)
      // All this means is that applets can't return "Remote" objects
      // as stubs, I hope...
    }
  }

  protected Object replaceObject(Object obj) throws IOException {
    if (obj instanceof java.rmi.Remote) {
      if (obj instanceof NinjaRemoteObject) {
	// XXX If the object isn't a NinjaRemoteObject we technically
	// shouldn't return anything - but - it might be a Ninja stub
	// already (e.g., in the registry, or a client passing an object
	// to another client). 
	return replaceObjectWithStub((NinjaRemoteObject)obj);
      }
    } 
    return obj;
  }

  protected void annotateClass(Class theclass) throws IOException {
    String codebase = null;
    String cname = theclass.getName();
     ;
    // Assume we get these from local CLASSPATH
    if ((!cname.startsWith("sun.")) && (!cname.startsWith("java."))) {

      // If the class has its own classloader, it was passed to us from another
      // RMI server and we're handing it off (that is, we're the registry).
      ClassLoader CL = theclass.getClassLoader();
      if (CL != null) {

	 ;
	
	if (CL instanceof NinjaClassLoader) {
	  NinjaClassLoader NCL = (NinjaClassLoader)CL;
	  codebase = NCL.getCodeBase().toExternalForm();
	   ;
	} else {
	   ;
	  codebase = null;
	}
      }
      if (codebase == null) {
	codebase = System.getProperty("java.rmi.server.codebase");
	if (codebase == null) {
	   ;
	}
      }
    }
      
     ;
    writeObject(codebase);
  }
    
  private Object replaceObjectWithStub(NinjaRemoteObject remoteobj) {
     ;
    Object stub = remoteobj.getStub();
    if (stub == null) {
       ;
    }
    return stub;
  }
}
    
    
    
