// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */





package ninja.rmi;

import java.io.*;
import java.net.*;

// An InputStream which gets the "codebase" URL from the opposite side
// for non-Sun classes - used on client side of RMI connection

class NinjaObjectInputStream extends ObjectInputStream {

  public NinjaObjectInputStream(InputStream is) throws IOException,
    StreamCorruptedException {
    super(is);
  }

  protected Class resolveClass(ObjectStreamClass osClass)
    throws IOException, ClassNotFoundException {

     ;

    Object obj = readObject();
    
//    try {
//      return super.resolveClass(osClass);
//    } catch (Exception e) {
//     System.out.println("NinjaObjectInputStream.resolveClass: got exception "+e.getMessage());
      // Do nothing?
//    }
    
    String cname = osClass.getName();
     ;
    try {
      // If we read a string at first, treat it as a URL
      if (obj != null && obj instanceof String) {
	String codebase = (String)obj;
	 ;
//	URL codebaseURL = new URL("file:/" + codebase);
	URL codebaseURL = new URL(codebase);
	 ;
	NinjaClassLoader ncl = new NinjaClassLoader(codebaseURL);
	Class theclass = ncl.loadClass(cname);
	 ;
	 ;
	
	 ;
	return theclass;
      } else {

        if (obj == null) {
	   ;
        } else  {
	   ;
        }
	 ;
        
	try {
	  return super.resolveClass(osClass);
	} catch (Exception e) {
	  throw new IOException("NinjaObjectInputStream: Object was null or not a string");
	}
      }
    } catch (Exception e) {
      throw new IOException("NinjaObjectInputStream can't resolve class "+cname+": "+e.getMessage());
    }
  }
}
    
    
    
