// NinjaRMI, by Matt Welsh (mdw@cs.berkeley.edu)
// See http://www.cs.berkeley.edu/~mdw/proj/ninja for details

/*
 * "Copyright (c) 1998 by The Regents of the University of California
 *  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */





package ninja.rmi;

import java.rmi.*;
import java.rmi.Remote;
import java.rmi.server.*;
import java.net.InetAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.DatagramPacket;

/**
 * An McastOw_ServerThread deals with incoming RMI connections on a
 * multicast UDP socket. Calls are unreliable and one-way (no return value 
 * or exceptions may be returned from the server method). 
 */
public class McastOw_ServerThread extends NinjaServerThread {
  private MulticastSocket serverSocket;
  private int port;
  private InetAddress ipaddr;
  private boolean active_call;
  private String curr_client_host;
  private int curr_client_port;

  McastOw_ServerThread(NinjaServerRef serverref, InetAddress theipaddr, int theport) throws Exception {
    super(serverref);
    if (theport != 0) {
      serverSocket = new MulticastSocket(theport);
    } else {
      serverSocket = new MulticastSocket();
    }
    ipaddr = theipaddr;
    serverSocket.joinGroup(ipaddr);
    port = serverSocket.getLocalPort();
    active_call = false;
  }

  /**
   * Returns the hostname of the client making the RMI call in this thread.
   */
  public String getClientHost() throws ServerNotActiveException {
    if (active_call == false) throw new ServerNotActiveException("Thread has no active client connection");
    return curr_client_host;
  }
  
  /**
   * Returns the remote port of the client making the RMI call in this thread.
   */
  public int getClientPort() throws ServerNotActiveException {
    if (active_call == false) throw new ServerNotActiveException("Thread has no active client connection");
    return curr_client_port;
  }

  /** 
   * Returns the port number on which the server is listening for new 
   * connections.
   */
  public int getServerPort() throws ServerNotActiveException {
    if (serverSocket == null) throw new ServerNotActiveException("Thread has no active server socket");
    return port;
  }

  /**
   * Returns the IP address of the multicast group on which the server
   * is listening.
   */
  public InetAddress getServerAddress() throws ServerNotActiveException {
    if (serverSocket == null) throw new ServerNotActiveException("Thread has no active server socket");
    return ipaddr;
  }

  // Listen on serverSocket for connections
  public void run() {
     ;

    // XXX mdw: Max rx size is 64k
    DatagramPacket dp = new DatagramPacket(new byte[64*1024], 64*1024);

  next_packet:
    while (true == true) {
      active_call = false;

      try {
	serverSocket.receive(dp);
      } catch (Exception e) {
	return;
      }
       
      BufferedInputStream bis;
      BufferedOutputStream bos;
      DataInputStream datais;
      DataOutputStream dataos;
      int i;
      short s;
      byte b;
      
      try {
	bis = new BufferedInputStream(new ByteArrayInputStream(dp.getData()));
	datais = new DataInputStream(bis);
	i = datais.readInt();
	s = datais.readShort();
	
      } catch (Exception e) {
	 ;
	continue next_packet;
      }
      
      if (i != 0x4e524d49 || s != 0x02) {
	 ;
	continue next_packet;
      }

      curr_client_host = dp.getAddress().getHostName();
      curr_client_port = dp.getPort();
      active_call = true;
      
       ;

      try {
	b = datais.readByte();
      } catch (Exception e) {
	 ;
	continue next_packet;
      }
	
      msg_switch: {
	switch (b) {
	case 0x50: // Call
	   ;
	  
	  NinjaRemoteCall call = new McastOw_RemoteCall(bis);
	  ObjectInput callis;
	  ObjID theobj;
	  
	  try {
	    callis = call.getInputStream();
	     ;
	    theobj = ObjID.read(callis);
	     ;
	  } catch (IOException e) {
	     ;
	    continue next_packet;
	  }

	  if (!servref.objid.equals(theobj)) {
	    // Do we care if the ObjID doesn't match?
	    if (servref.exportData.check_objid == true) {
	      System.out.println("McastOw_ServerThread["+port+"]: ObjID doesn't match");
	      continue next_packet;
	    }
	  }
	  
	  int op;
	  long hash;
	  
	  try {
	    op = callis.readInt();
	    hash = callis.readLong();
	  } catch (IOException e) {
	     ;
	    continue next_packet;
	  }
	  
	   ;
	  try {
	    servref.skeleton.dispatch(servref.remote, call, op, hash);
	  } catch(Exception e) {
	     ;
	    e.printStackTrace();

	  }
	    
	  break;
	    
	  default:
	     ;
	    continue next_packet;
	    
	}
      }
    }
  }
  
}
