package whiteboard;

import java.io.*;
import java.util.*;

import java.rmi.*;
import java.rmi.registry.*;

//import java.rmi.server.*;
import ninja.rmi.NinjaRemoteObject;
import ninja.rmi.NinjaExportData;
import ninja.rmi.registry.*;

import JavaGroups.*;

public class WhiteboardServer extends NinjaRemoteObject implements ScribbleServer, Runnable
{	
	Vector		listeners;
	Vector		scribbles;
	Channel		channel;
	Thread		serverThread=null;

	boolean		activeServer=false;
	boolean		rc=false;

	final int WHITEBOARDEVENT=100;
	final int ADDSCRIBBLELISTENER=101;
	final int REMOVESCRIBBLELISTENER=102;
	
	Registry reg = null;	
	
  public WhiteboardServer(Registry reg, String serviceName) throws Exception   // ninja
  {
		super(serviceName);
		this.reg = reg;
		listeners=new Vector();
		scribbles=new Vector();

		channel=new JChannel("UDP:PING:FD:GMS:STATE_TRANSFER:QUEUE");
		channel.SetOpt(Channel.GET_STATE_EVENTS, new Boolean(true));
		channel.Connect("ServerState");
		serverThread=new Thread(this);
		serverThread.start();

		System.out.println("Getting state");

		rc=channel.GetState(3000);

		System.out.println("GetState(), rc=" + rc);		
	}

  public void run() {
	  Object ret=null;
	  Object newOb=null;

	  while(true) {
			try {
				ret=channel.Receive(0);
				System.out.println("Received Some thing");	
				

				if(ret instanceof Message) {
//					System.out.println("Message Event");	
					Message m=(Message)ret;
					
					int action=Integer.parseInt((String)m.RemoveHeader());
//					System.out.println("Action: "+action);
					
					try {
						newOb=(Util.ObjectFromByteBuffer(m.GetBuffer()));
						
						switch (action){
						case WHITEBOARDEVENT:
							if (newOb instanceof WhiteboardEvent)
								handleEvent_Imp((WhiteboardEvent)newOb);
							else System.out.println("Cast Error 0");
							break;
						case ADDSCRIBBLELISTENER:
							if (newOb instanceof ScribbleListener)
								addScribbleListener_Imp((ScribbleListener)newOb);
							else System.out.println("Cast Error 1");
							break;
						case REMOVESCRIBBLELISTENER:
							if (newOb instanceof ScribbleListener)
								removeScribbleListener_Imp((ScribbleListener)newOb);
							else System.out.println("Cast Error 2");
							break;
						default:
							System.out.println("Please add new action event here");
						}
					}	catch(ClassCastException cast_ex) {
						System.out.println("Contents of buffer was no Event !");
					}	catch(Exception e) {
						e.printStackTrace();
					}
				} else if(ret instanceof GetStateEvent) {
					System.out.println("----> State transfer: " + ret);
					Vector[] tmp=new Vector[2];
					tmp[0]=listeners;
					tmp[1]=scribbles;
					channel.ReturnState(tmp);
				}	else if(ret instanceof SetStateEvent) {
					System.out.println("----> Set State Event");
					Vector[] new_state=new Vector[2];
					new_state=(Vector[])((SetStateEvent)ret).GetArg();
					if(new_state != null) {
						listeners=(Vector)new_state[0];
						scribbles=(Vector)new_state[1];
					}
				} else System.out.println("Unknow Event: ret=" +ret);
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
	}

 	public void sendNewState(Object send, int action) throws RemoteException {
		Message update=new Message(null, null, null);
		//	String name=send.getClass().getName();
		try {
			update.AddHeader(Integer.toString(action));
			update.SetBuffer(Util.ObjectToByteBuffer((Serializable)send));
			channel.Send(update);
		} catch(Exception e) {
			System.out.println("Send New State Error: "+e.getMessage());
			e.printStackTrace();
		}
	}
  
  public void addScribbleListener(ScribbleListener l) throws RemoteException
  {		
		sendNewState(l, ADDSCRIBBLELISTENER);
	  //		System.out.println("addScribbleListener");
  }

  public void removeScribbleListener(ScribbleListener l) throws RemoteException
  {
		//System.out.println("removeScribbleListener");
		sendNewState(l, REMOVESCRIBBLELISTENER);
  }
  
    public void handleEvent(WhiteboardEvent e) throws RemoteException
	{
	  System.out.println("server: handleEvent! \n");
	  	sendNewState(e, WHITEBOARDEVENT);
	}
 
  
  public void addScribbleListener_Imp(ScribbleListener l) throws RemoteException
  {		
	//	System.out.println("addScribbleListenerToLocal");
    ScribbleListener listener = null;

    try {
			String address = l.getClientAddress();
			listener = (ScribbleListener) reg.lookup("//" + address + "/" + l.getClientName());  //ninja
		}
	catch (Exception exc) {
		System.out.println("<SERVER ERROR:>" + exc.getMessage());
		exc.printStackTrace();
	}

    if(!listeners.contains(listener)) {
			listeners.addElement(listener);
			System.out.println(listener.getClientName() + " connecting");
			updateScribbleListener(listener);
		}

  }

	public void removeScribbleListener_Imp(ScribbleListener l) throws RemoteException
  {		
		//System.out.println("removeScribbleListenerFromLocal");

    if(listeners.contains(l)) {
			System.out.println(l.getClientName() + " disconnecting");
			listeners.removeElement(l);
			listeners.trimToSize();
		}
  }

	public void removeScribbleListener_Imp(int i)
  {		
	System.out.println("removeScribbleListener at element i");
	System.out.println(listeners.size());

//    if(listeners.elementAt(i)!=null) {
//			System.out.println(((ScribbleListener)(listeners.elementAt(i))).getClientName()+ " disconnecting");
			listeners.removeElementAt(i);
	System.out.println(listeners.size());
			listeners.trimToSize();
	System.out.println(listeners.size());
//		}
  }

	public void handleEvent_Imp(WhiteboardEvent e) throws RemoteException
	{		
		//System.out.println("handleEventInLocal");
		if(e instanceof ClearEvent)
			scribbles.removeAllElements();
		else
			scribbles.addElement(e);

		deliverEvent(e);
  }
  
  private synchronized void deliverEvent(WhiteboardEvent e)
  {
	  Vector cloned = (Vector) listeners.clone();

	  for(int i=0; i<cloned.size(); i++) {
			ScribbleListener l = (ScribbleListener) cloned.elementAt(i);
			try {
				l.handleEvent(e);
				System.out.println("inform the " + (i+1) + "th client of the event\n");
			}	catch(RemoteException exc) {
				System.out.println("This client exited!");
				removeScribbleListener_Imp(i);
/*				try {
					removeScribbleListener_Imp(i);
//					removeScribbleListener(l);
				} catch (RemoteException re){
					System.out.println("<DELIVEREVENT>");
					re.printStackTrace();
				}
*/			}
		}
  }

  private synchronized void updateScribbleListener(ScribbleListener l)
  {
    Vector cloned = (Vector) scribbles.clone();

    for(int i=0; i<cloned.size(); i++) {
			WhiteboardEvent e = (WhiteboardEvent) cloned.elementAt(i);
			try	{
				l.handleEvent(e);
			}	catch(RemoteException exc) {
				System.out.println("<SERVER>");
				exc.printStackTrace();
			}
		}
  }

  public static void main(String[] args) {
    
	Registry reg = null;  
	try {
			System.setSecurityManager(new RMISecurityManager());
		} catch (java.rmi.RMISecurityException exc) {
			exc.printStackTrace();
		}
		
    WhiteboardServer server = null;
	String regHost = args[0];
	String portNum = args[1];
	
	try {
      System.out.println("Connecting to registry on "+regHost); //":port...");
//      reg = (Registry)NinjaLocateRegistry.getNewRegistry(regHost, Integer.parseInt(portNum));
      reg = (Registry)NinjaLocateRegistry.getRegistry(regHost, Integer.parseInt(portNum));
	}
	catch (Exception e) {
      System.out.println("RmiClient exception: " + e.getMessage());
      e.printStackTrace();
    }	
	
	String serviceName="WHITEBOARD-SERVER";
	try {
			server = new WhiteboardServer(reg,serviceName);
		} catch (java.rmi.RemoteException exc) {
			exc.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
    try {
			reg.rebind(serviceName,server); // ninja
		} catch (java.rmi.RemoteException exc) {
			exc.printStackTrace();
		} catch (Exception exc) {
			exc.printStackTrace();
			System.out.println("Binding failure!! \n");
			System.exit(1);
		}
  }
  
}