package whiteboard;

import java.io.*;
import java.util.*;
import java.rmi.*;
//import java.rmi.server.*;
import JavaGroups.*;

import ninja.rmi.NinjaRemoteObject;
import ninja.rmi.NinjaExportData;
import ninja.rmi.registry.*;
import java.rmi.registry.*;

public class WhiteboardServer extends NinjaRemoteObject implements ScribbleServer, Runnable
{
	Vector		listeners;
	Vector		scribbles;
	Vector		storeEvents;
	Vector		actions;
	Channel		channel;
	Thread		serverThread=null;
	Thread		periodThread=null;
	PeriodUpdateState pus=null;
	boolean		activeServer=false;
	boolean		rc=false;
	Registry	reg = null;
	
	final int PERIODUPDATE=0;
	final int WHITEBOARDEVENT=100;
	final int ADDSCRIBBLELISTENER=101;
	final int REMOVESCRIBBLELISTENER=102;
	
  public WhiteboardServer(Registry reg, String serviceName) throws Exception   // ninja
  {
	  super(serviceName);
	  
		this.reg = reg;
		listeners=new Vector();
		scribbles=new Vector();
	  
	    channel=new JChannel("UDP:PING:FD:GMS:STATE_TRANSFER:QUEUE");
		channel.SetOpt(Channel.GET_STATE_EVENTS, new Boolean(true));
		channel.Connect("ServerState");

		serverThread=new Thread(this);
		serverThread.start();
		storeEvents=new Vector();
		actions=new Vector();
		System.out.println("Getting state");
		rc=channel.GetState(3000);

		System.out.println("GetState(), rc=" + rc);

		pus=new PeriodUpdateState(this);
  }

  public void storeNewState(Object send, int action) throws RemoteException {
    
	switch (action){
	case WHITEBOARDEVENT:
		if (send instanceof WhiteboardEvent){
			WhiteboardEvent wbe=(WhiteboardEvent)send;
			if (wbe instanceof ClearEvent)
				sendNewState(send, action);
			else {
				storeEvents.addElement(send);
				actions.addElement(new Integer(action));
			}
		} else System.out.println("Cast Error 1");
		break;
	case ADDSCRIBBLELISTENER:
		if (send instanceof ScribbleListener) {
			storeEvents.addElement(send);
			actions.addElement(new Integer(action));
//			addScribbleListenerToLocal((ScribbleListener)newOb);
		}
		else System.out.println("Cast Error 2");
		break;
	case REMOVESCRIBBLELISTENER:
		if (send instanceof ScribbleListener) {
			storeEvents.addElement(send);
			actions.addElement(new Integer(action));
		}
		else System.out.println("Cast Error 3");
		break;
	}
  }
  
	public synchronized void sendNewState() throws RemoteException {
		if (storeEvents.isEmpty()) return;
		
		Message update=new Message(null, null, null);		// what kind of message ?
		//	String name=send.getClass().getName();
				    
		try {
			update.AddHeader(Integer.toString(PERIODUPDATE));
			Vector[] tmp=new Vector[2];
			tmp[0]=storeEvents;
			tmp[1]=actions;
			update.SetBuffer(Util.ObjectToByteBuffer((Serializable)tmp));
			channel.Send(update);
		} catch(Exception e) {
			e.printStackTrace();
		}
		storeEvents.removeAllElements();
		actions.removeAllElements();
	}

	public void sendNewState(Object send, int action) throws RemoteException {
    Message update=new Message(null, null, null);		// what kind of message ?
	//	String name=send.getClass().getName();
	// System.out.println("This is a clear event!");
			    
    try {
			update.AddHeader(Integer.toString(action));
			update.SetBuffer(Util.ObjectToByteBuffer((Serializable)send));
			channel.Send(update);
		} catch(Exception e) {
			e.printStackTrace();
	  }
	}

	public void run() {
		Object ret=null;
		Object newOb=null;

    while(true) {
			try {
				ret=channel.Receive(0);
				// System.out.println("Receive some thing!");

				if(ret instanceof Message) {
//					System.out.println("Message Event");	
					Message m=(Message)ret;
					
					int action=Integer.parseInt((String)m.RemoveHeader());
//					System.out.println("Action: "+action);
					
					try {
						newOb=(Util.ObjectFromByteBuffer(m.GetBuffer()));
						
						switch (action){
						case PERIODUPDATE:
							Vector[] tmp=(Vector[])newOb;
							handleUpdateMessage(tmp);									
							break;
						case WHITEBOARDEVENT:
							if (newOb instanceof WhiteboardEvent)
								handleEvent_Imp((WhiteboardEvent)newOb);
							else System.out.println("Cast Error 0");
							break;
						default:
							System.out.println("Please add new action event here");
						}
					}	catch(ClassCastException cast_ex) {
						System.out.println("Contents of buffer was no Event !");
					}	catch(Exception e) {
						e.printStackTrace();
					}
				} else if(ret instanceof GetStateEvent) {
					System.out.println("----> State transfer: " + ret);
					Vector[] tmp=new Vector[2];
					tmp[0]=listeners;
					tmp[1]=scribbles;
					channel.ReturnState(tmp);
				}	else if(ret instanceof SetStateEvent) {
					System.out.println("----> Set State Event");
					Vector[] new_state=new Vector[2];
					new_state=(Vector[])((SetStateEvent)ret).GetArg();
					if(new_state != null) {
						listeners=(Vector)new_state[0];
						scribbles=(Vector)new_state[1];
					}
				} // else System.out.println("Unknow Event: ret=" +ret);
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
	}

	public synchronized void handleUpdateMessage(Vector[] se) throws RemoteException {
		Vector ev=(Vector)se[0];
		Vector act=(Vector)se[1];
		Object newOb;
		for (int i=0; i<ev.size();i++) {
			newOb=ev.elementAt(i);
			
			int action=((Integer)(act.elementAt(i))).intValue();
			
			switch (action){
			case WHITEBOARDEVENT:
				if (newOb instanceof WhiteboardEvent)
					handleEvent_Imp((WhiteboardEvent)newOb);
				else System.out.println("Cast Error 0");
				break;
			case ADDSCRIBBLELISTENER:
				if (newOb instanceof ScribbleListener)
					addScribbleListener_Imp((ScribbleListener)newOb);
				else System.out.println("Cast Error 1");
				break;
			case REMOVESCRIBBLELISTENER:
				if (newOb instanceof ScribbleListener)
					removeScribbleListener_Imp((ScribbleListener)newOb);
				else System.out.println("Cast Error 2");
				break;
			default:
				System.out.println("Please add new action event here");
			}
		}
	}									

	public void addScribbleListener(ScribbleListener l) throws RemoteException
  {		
		storeNewState(l, ADDSCRIBBLELISTENER);
	  //		System.out.println("addScribbleListener");
	}
	
  public synchronized void addScribbleListener_Imp(ScribbleListener l) throws RemoteException
  {		
	//	System.out.println("addScribbleListenerToLocal");
    ScribbleListener listener = null;

    try {
			String address = l.getClientAddress();
			listener = (ScribbleListener) reg.lookup("//" + address + "/" + l.getClientName());  //ninja
		}
	catch (Exception exc) {
		System.out.println("<SERVER ERROR:>" + exc.getMessage());
		exc.printStackTrace();
	}

    if(!listeners.contains(listener)) {
			listeners.addElement(listener);
			System.out.println(listener.getClientName() + " connecting");
			updateScribbleListener(listener);
		}

  }

  public void removeScribbleListener(ScribbleListener l) throws RemoteException
  {
		//System.out.println("removeScribbleListener");
		storeNewState(l, REMOVESCRIBBLELISTENER);
  }

  public synchronized void removeScribbleListener_Imp(ScribbleListener l) throws RemoteException
  {		
		//System.out.println("removeScribbleListenerFromLocal");

    if(listeners.contains(l)) {
			System.out.println(l.getClientName() + " disconnecting");
			listeners.removeElement(l);
			listeners.trimToSize();
		}
  }
  
  public void removeScribbleListener_Imp(int i)
  {		
	  listeners.removeElementAt(i);
	  listeners.trimToSize();
  }

  public void handleEvent(WhiteboardEvent e) throws RemoteException
  {
	  if (!activeServer) {
		  activeServer=true;
		  System.out.println("This is a Active Server!\n");
	  }
	  	storeNewState(e, WHITEBOARDEVENT);
	}

	public synchronized void handleEvent_Imp(WhiteboardEvent e) throws RemoteException
  {		
	 if (e==null){
		 System.out.println("This is null event!");
		 return ;
	 }
	 try {
		 
		if(e instanceof ClearEvent) {
			scribbles.removeAllElements();
			storeEvents.removeAllElements();			// special case
		} else
			scribbles.addElement(e);
		
		deliverEvent(e);
	  } catch (NullPointerException ne){
		  ne.printStackTrace();
	  }
  }
  
  private synchronized void deliverEvent(WhiteboardEvent e)
  {
		  
	    Vector cloned = (Vector) listeners.clone();
	    
	    for(int i=0; i<cloned.size(); i++) {
				ScribbleListener l = (ScribbleListener) cloned.elementAt(i);
				try {
					l.handleEvent(e);
					// System.out.println("inform the " + (i+1) + "th client of the event\n");
				}	catch(RemoteException exc) {
					System.out.println("One client exited!");
					removeScribbleListener_Imp(i);				
	//				System.out.println("<SERVER>");
	//				exc.printStackTrace();
				}
			}
  }

  private synchronized void updateScribbleListener(ScribbleListener l)
  {
    Vector cloned = (Vector) scribbles.clone();

    for(int i=0; i<cloned.size(); i++) {
			WhiteboardEvent e = (WhiteboardEvent) cloned.elementAt(i);
			try	{
				l.handleEvent(e);
			}	catch(RemoteException exc) {
				removeScribbleListener_Imp(i);
		
//				System.out.println("<SERVER>");
//				exc.printStackTrace();
			}
		}
  }

  public static void main(String[] args) {
    
	Registry reg = null;  
	try {
			System.setSecurityManager(new RMISecurityManager());
		} catch (java.rmi.RMISecurityException exc) {
			exc.printStackTrace();
		}
		
    WhiteboardServer server = null;
	String regHost = args[0];
	String portNum = args[1];
	
	try {
      System.out.println("Connecting to registry on "+regHost); //":port...");
      reg = (Registry)NinjaLocateRegistry.getRegistry(regHost, Integer.parseInt(portNum));
	}
	catch (Exception e) {
      System.out.println("RmiClient exception: " + e.getMessage());
      e.printStackTrace();
    }	
	
	String serviceName="WHITEBOARD-SERVER";
	try {
			server = new WhiteboardServer(reg, serviceName);
		} catch (java.rmi.RemoteException exc) {
			exc.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
    try {
			reg.rebind(serviceName,server); // ninja
		} catch (java.rmi.RemoteException exc) {
			exc.printStackTrace();
		} catch (Exception exc) {
			exc.printStackTrace();
			System.out.println("Binding failure!! \n");
			System.exit(1);
		}
  }
  
}