package whiteboard;
import java.awt.*;
import java.awt.event.*;


class WhiteboardQuiter extends WindowAdapter
{
  Frame frame;
  ScribbleServer server;
  ScribbleListener client;

  public WhiteboardQuiter(Frame f, ScribbleServer s, ScribbleListener c)
  {
    frame = f;
    server = s;
    client = c;
  }

  public void windowClosing(WindowEvent e)
  {
    try
      {
	server.removeScribbleListener(client);
      }
    catch(java.rmi.RemoteException exc)
      {
	exc.printStackTrace();
      }

    frame.dispose();
    System.exit(0);
  }
}