package whiteboard;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.rmi.*;
//import java.rmi.server.*;
import java.util.*;
import java.io.*;

import ninja.rmi.*;
import ninja.rmi.registry.*;
import java.rmi.registry.*;

public class WhiteboardClient extends NinjaRemoteObject implements ScribbleListener, MouseListener, MouseMotionListener
{
  Vector scribbles;
  ScribbleServer server;
  Whiteboard whiteboard;
  ColorPanel colorpanel;
  String regHost,clientname;
  String localAddress;
  Registry reg;
  Frame f;
  
  NinjaRemoteRef ninjaremoteref;  //ninja

  Color mycolor;

  public WhiteboardClient(String regHost, String localAddress, String clientName, 
						  Registry reg, String serviceName) throws RemoteException
  {
    super(serviceName);
    this.clientname = clientName;
	this.reg = reg;
	this.regHost = regHost;
	this.localAddress = localAddress;
	
	scribbles = new Vector();
    
    whiteboard = new Whiteboard(scribbles);
    whiteboard.addMouseListener((MouseListener) this);
    whiteboard.addMouseMotionListener((MouseMotionListener) this);

    f = new Frame();
    f.setTitle(clientname + "'s whiteboard");
    f.setLayout(new BorderLayout());
    f.add("Center", whiteboard);
    f.setSize(200,200);
    f.validate();
    f.show();
    
    mycolor = Color.black;
  }
  
  public void bind(ScribbleServer s)
  {
    server = s;
    try
      {
	server.addScribbleListener(this);
      }
    catch (RemoteException exc)
      {
	exc.printStackTrace();
      }
    
    colorpanel = new ColorPanel(server,this);
    f.add("North",colorpanel);
    f.addWindowListener(new WhiteboardQuiter(f,s,this));
    f.validate();
  }

  public String getClientAddress() throws RemoteException
  {
    return(localAddress);
  }

  public String getClientName() throws RemoteException
  {
    return clientname;
  }

  public void setColor(Color c)
  {
    mycolor = c;
  }
  
  public synchronized void handleEvent(WhiteboardEvent e) throws RemoteException
  {
    if(e instanceof ClearEvent)
      scribbles.removeAllElements();
    else if(e instanceof ImageEvent)
      {
	ImageEvent ie = (ImageEvent) e;
	whiteboard.useImage(ie.getImage());
      }
    else
      scribbles.addElement(e);
    
    whiteboard.repaint();
  }
  
  public void mouseClicked(MouseEvent e)
  {
  }

  public void mouseEntered(MouseEvent e)
  {
  }

  public void mouseExited(MouseEvent e)
  {
  }

  public void mousePressed(MouseEvent e)
  {
    ScribbleEvent se = new ScribbleEvent(this,e.getPoint());
    try
      {
	server.handleEvent(se);
      }
    catch (RemoteException exc)
      {
	System.out.println(exc);
      }

    if(!mycolor.equals(whiteboard.getLastDrawnColor()))
      {
	ColorChangeEvent cce = new ColorChangeEvent(this,mycolor);
	try
	  {
	    server.handleEvent(cce);
	  }
	catch (RemoteException exc)
	  {
	    System.out.println(exc);
	  }
      }
  }

  public void mouseReleased(MouseEvent e)
  {
    ScribbleEvent se = new ScribbleEvent(this,new Point(-1,-1));

    try
      {
		System.out.println("send event to server...\n");
		server.handleEvent(se);
		System.out.println("sent event to server! \n");
      }
    catch (RemoteException exc)
      {
	System.out.println(exc);
      }

    System.gc();
  }

  public void mouseDragged(MouseEvent e)
  {
    ScribbleEvent se = new ScribbleEvent(this,e.getPoint());
    try
      {
	server.handleEvent(se);
      }
    catch (RemoteException exc)
      {
	System.out.println(exc);
      }
  }

  public void mouseMoved(MouseEvent e)
  {
  }

  public static void main(String[] args)
  {
		Registry reg = null;
	    String localAddress=null;
		
		String regHost=args[0];  // ninja registry host
		String portNum = args[1]; // port number
		String clientName=args[2];  // client name
		String name0=null;
		String serviceName="WHITEBOARD-SERVER";
		
	try {
		localAddress=(InetAddress.getLocalHost()).getHostName();
	} catch (java.net.UnknownHostException uhe) {
		uhe.printStackTrace();
	}
		
	try {
      System.out.println("Connecting to registry on "+regHost); //":port...");
      reg = (Registry)NinjaLocateRegistry.getRegistry(regHost, Integer.parseInt(portNum));
	}
	catch (Exception e) {
      System.out.println("RmiClient exception: " + e.getMessage());
      e.printStackTrace();
    }	
		
    try
      {
	System.setSecurityManager(new RMISecurityManager());
      }
    catch (java.rmi.RMISecurityException exc)
      {
	exc.printStackTrace();
      }
    
    WhiteboardClient client = null;
    try
      {
	client = new WhiteboardClient(regHost, localAddress, clientName, reg, serviceName);
      }
    catch (RemoteException exc)
      {
      }

    try
      {
		reg.rebind("//" + localAddress + '/' + clientName, client); //ninja
      }
    catch (java.rmi.RemoteException exc)
      {
	exc.printStackTrace();
      }
    catch (Exception exc)
      {
		exc.printStackTrace();
		System.out.println("CLIENT ERROR: " + exc.getMessage());
		System.exit(1);
      }
    
    ScribbleServer server = null;
    try
      {
	server = (ScribbleServer) reg.lookup(serviceName);  //ninja
      }
    catch (java.rmi.NotBoundException exc)
      {
	exc.printStackTrace();
      }
    catch (java.rmi.RemoteException exc)
      {
	exc.printStackTrace();
      }
    catch (Exception exc)
      {
		exc.printStackTrace();
		System.out.println("CLIENT ERROR: " + exc.getMessage());
		System.exit(1);
      }
    
    if(server instanceof ScribbleServer)
      {
	client.bind(server);
      }
    else
      {
	if(server == null)
	  System.out.println("RMI error: Server was not found");
	else
	  System.out.println("RMI error: The server was found but is not of a known type");
      }
    
  }

}
