package whiteboard;
import java.awt.*;
import java.awt.event.*;
import java.util.*;



public class Whiteboard extends ImagePanel
{
  Vector scribbles;
  Color lastcolor;
  Image image;

  public Whiteboard(Vector s)
  {
    scribbles = s;
    lastcolor = Color.black;
    image = null;
  }

  public void paint(Graphics g)
  {
    Dimension d = getSize();
    Dimension max = maxSize();
    Dimension thesize = new Dimension(Math.max(d.width-4, max.width),
				      Math.max(d.height-4,max.height));
    if(image != null)
      thesize.setSize(Math.max(thesize.width,image.getWidth(this)),
		      Math.max(thesize.height,image.getHeight(this)));
    try
      {
	Image offscreen = createImage(thesize.width, thesize.height);
	Graphics offg = offscreen.getGraphics();
	offg.setColor(Color.white);
	offg.fillRect(0, 0, d.width, d.height);
	offg.setColor(Color.black);
	
	if(image != null)
	  offg.drawImage(image,0,0,this);
	

	Point last = null;
	for(int i=0; i<scribbles.size(); i++)
	  {
	    WhiteboardEvent e = (WhiteboardEvent) scribbles.elementAt(i);
	    if(e instanceof ColorChangeEvent)
	      {
		ColorChangeEvent cce = (ColorChangeEvent) e;
		lastcolor = cce.getColor();
		offg.setColor(lastcolor);
	      }
	    else if(e instanceof ScribbleEvent)
	      {
		ScribbleEvent se = (ScribbleEvent) e;
		Point p = se.getPoint();
		if(p.x == -1 && p.y == -1)
		  {
		    last = null;
		  }
		else if (last == null)
		  last = p;
		else
		  {
		    offg.drawLine(last.x, last.y, p.x+1, p.y+1);
		    last = p;
		  }
	      }
	  }
	offg.dispose();
	setImage(offscreen);
      }
    catch(java.lang.OutOfMemoryError e)
      {
	System.gc();
	System.out.println("Garbage Collecting...");
      }
  }
  
  public void update(Graphics g)
  {
    paint(g);
  }

  public Color getLastDrawnColor()
  {
    return lastcolor;
  }

  public void useImage(Image i)
  {
    image = i;
  }
  
  private Dimension maxSize()
  {
    int maxX = 0;
    int maxY = 0;
    for(Enumeration e = scribbles.elements(); e.hasMoreElements();)
      {
	WhiteboardEvent we = (WhiteboardEvent) e.nextElement();
	if(we instanceof ScribbleEvent)
	  {
	    ScribbleEvent se = (ScribbleEvent) we;
	    Point p = se.getPoint();
	    if(p.x > maxX)
	      maxX = p.x;
	    if(p.y > maxY)
	      maxY = p.y;
	  }
      }
    
    return new Dimension(maxX,maxY);
  }

  public void addMouseListener(MouseListener l)
  {
    ic.addMouseListener(l);
  }

  public void addMouseMotionListener(MouseMotionListener l)
  {
    ic.addMouseMotionListener(l);
  }
}
