package whiteboard;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class ImagePanel extends ScrollPane
{
  ImageCanvas ic;
  int maxwidth = 0;
  int maxheight = 0;

  Image image;

  public ImagePanel()
  {
    super();

    setBackground(Color.white);

    addComponentListener(new ScrollSetter(this));
    ic = new ImageCanvas();
    add(ic);
    validate();
  }
  
  public Dimension getMaximumSize()
  {
    return new Dimension(image.getWidth(this),
			 image.getHeight(this));
  }

  /**does the layout for the scrollbars*/
  public void doLayout()
  {
    super.doLayout(); 
  }

  /**sets the image to be displayed*/
  public void setImage(Image i)
  {
    image = i;
    if(image != null)
      {
	maxwidth = image.getWidth(this);
	maxheight = image.getHeight(this);
      }
    ic.setImage(image);
    doLayout();
  }
}

/**checks whether or not to display scrollbars*/
class ScrollSetter extends ComponentAdapter
{
  ScrollPane sp;

  public ScrollSetter(ScrollPane scroll)
  {
    sp = scroll;
  }
  
  public void componentResized(ComponentEvent e)
  {
    sp.doLayout();
  }
}
