package whiteboard;
import java.awt.*;
import java.awt.image.*;

public class ImageEvent extends WhiteboardEvent
{
  int[] data = null;
  int w,h;

  public ImageEvent(Object source, Image i)
  {
    super(source);
    Panel p = new Panel();

    if(i != null)
      {
	w = i.getWidth(p);
	h = i.getHeight(p);
	data = new int[w * h];
	data = handlepixels(i,0,0,w,h);
      }
  }

  public Image getImage()
  {
    if(data != null)
      {
	MemoryImageSource source = new MemoryImageSource(w,h,data,0,w);
	Image i = Toolkit.getDefaultToolkit().createImage(source);
	return i;
      }
    else
      return null;
  }

  private void handlesinglepixel(int x, int y, int pixel) 
  {
    int alpha = (pixel >> 24) & 0xff;	
    int red   = (pixel >> 16) & 0xff;
    int green = (pixel >>  8) & 0xff;	
    int blue  = (pixel      ) & 0xff;
    // Deal with the pixel as necessary... 
  }
  
  private int[] handlepixels(Image img, int x, int y, int w, int h) 
  {
    int[] pixels = new int[w * h];
    PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);	
    try 
      {
	pg.grabPixels();	
      } 
    catch (InterruptedException e) 
      {
	System.err.println("interrupted waiting for pixels!");	    
	return pixels;	
      }
    if ((pg.getStatus() & ImageObserver.ABORT) != 0) 
      {
	System.err.println("image fetch aborted or errored");	    
	return pixels;	
      }
    for (int j = 0; j < h; j++) 
      {	    
	for (int i = 0; i < w; i++) 
	  {
	    handlesinglepixel(x+i, y+j, pixels[j * w + i]);	    
	  }	
      }
    return pixels;
  }
}
