package whiteboard;
import java.awt.*;
import java.awt.image.*;

/**this class is where the image is displayed*/

public class ImageCanvas extends Canvas
{
  Image image;

  public ImageCanvas()
  {
    super();
    image = null;
  }
  
  public Dimension getPreferredSize()
  {
    if(image==null)
      return new Dimension(0,0);
    else
      return new Dimension(image.getWidth(this),image.getHeight(this));
  }

  /**sets the image that is displayed*/
  public void setImage(Image i)
  {
    image = i;
    if(image != null)
    {
      int width = image.getWidth(this);
      int height = image.getHeight(this);
      this.setSize(width,height);
      repaint();
    }
  }

  public void update(Graphics g)
  {
    paint(g);
  }

  /**displays image and translate it if necessary*/
  public void paint(Graphics g)
  {
    if(image!=null)
	g.drawImage(image,0,0,this);
  }
}