package whiteboard;
import java.awt.*;
import java.awt.event.*;
import java.rmi.*;

public class ColorPanel extends Panel
{
  Button black, blue, red, yellow, green, clear, image, clearimage;
  ScribbleServer server;
  ScribbleListener client;
  
  public ColorPanel(ScribbleServer s, ScribbleListener c)
  {
    super();
    server = s;
    client = c;

    black = new Button("Black");
    black.addActionListener(new ColorButtonListener(Color.black,server,client));
    blue = new Button("Blue");
    blue.addActionListener(new ColorButtonListener(Color.blue,server,client));
    red = new Button("Red");
    red.addActionListener(new ColorButtonListener(Color.red,server,client));
    yellow = new Button("Yellow");
    yellow.addActionListener(new ColorButtonListener(Color.yellow,server,client));
    green = new Button("Green");
    green.addActionListener(new ColorButtonListener(Color.green,server,client));
    clear = new Button("Clear");
    clear.addActionListener(new ColorButtonListener(null,server,client));
    image = new Button("Image");
    image.addActionListener(new ImageButtonListener(this,server,client));
    clearimage = new Button("Clear Image");
    clearimage.addActionListener(new ImageClearListener(server,client));

    setLayout(new GridLayout(2,4));
    add(black);
    add(blue);
    add(red);
    add(yellow);
    add(green);
    add(clear);
    add(image);
    add(clearimage);
  }
}

class ColorButtonListener implements ActionListener
{
  Color color;
  ScribbleServer server;
  ScribbleListener client;

  public ColorButtonListener(Color c, ScribbleServer s, ScribbleListener cl)
  {
    color = c;
    server = s;
    client = cl;
  }
  
  public void actionPerformed(ActionEvent e)
  {
    if(color != null)
      {
	((WhiteboardClient) client).setColor(color);
	ColorChangeEvent cce = new ColorChangeEvent(client,color);
	try
	  {
	    server.handleEvent(cce);
	  }
	catch(RemoteException exc)
	  {
	    exc.printStackTrace();
	  }
      }
    else
      {
	ClearEvent ce = new ClearEvent(client);
	try
	  {
	    server.handleEvent(ce);
	  }
	catch(RemoteException exc)
	  {
	    exc.printStackTrace();
	  }
      }
  }
}

class ImageButtonListener implements ActionListener
{
  ScribbleServer server;
  ScribbleListener client;
  ColorPanel cp;

  public ImageButtonListener(ColorPanel panel, ScribbleServer s, ScribbleListener c)
  {
    cp = panel;
    server = s;
    client = c;
  }

  public void actionPerformed(ActionEvent e)
  {
    MediaTracker mt = new MediaTracker(cp);
    String filename = ImageLoader.loadImage();
    if(filename != null)
      {
	Image i = Toolkit.getDefaultToolkit().getImage(filename);
	mt.addImage(i,0);
	
	try
	  {
	    mt.waitForAll();
	  }
	catch (InterruptedException exc)
	  {
	    exc.printStackTrace();
	  }
	
	ImageEvent ie = new ImageEvent(client,i);
	
	try
	  {
	    server.handleEvent(ie);
	  }
	catch(java.rmi.RemoteException exc)
	  {
	    exc.printStackTrace();
	  }
      }
  }
}

class ImageClearListener implements ActionListener
{
  ScribbleServer server;
  ScribbleListener client;

  public ImageClearListener(ScribbleServer s, ScribbleListener c)
  {
    server = s;
    client = c;
  }

  public void actionPerformed(ActionEvent e)
  {
    ImageEvent ie = new ImageEvent(client,null);
    
    try
      {
	server.handleEvent(ie);
      }
    catch (java.rmi.RemoteException exc)
      {
	exc.printStackTrace();
      }
  }
}