
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;
import java.io.*;
import JavaGroups.*;
import JavaGroups.GMP.*;





public class GmpTest extends Applet implements MembershipListener {
    private Topology               top;
    private OID                    my_oid;


    public void init() {
	Transport    transport;
	Dispatcher   dispatcher;
	GMP          gmp;
	try {
	    top=new Topology();
	    top.setLayout(null);
	    top.setSize(220,507);
	    transport=new Transport();
	    dispatcher=new Dispatcher(transport);
	    gmp=new GmpImpl(dispatcher);
	    gmp.GmpAddListener(this);
	    ((GmpImpl)gmp).FdAddFailureDetectorListener(top);
	    gmp.GmpStart();
	    top.show();
	}
	catch(SecurityException sec) {
	    System.err.println("Caught security exception !");
	    System.exit(1);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }



    /* --------------- Callbacks --------------- */

    public void MemberJoined(UnicastAddress member_addr) {
	top.AddNode(member_addr);
    }

    public void MemberLeft(UnicastAddress member_addr) {
	top.RemoveNode(member_addr);
    }

    public void SetState(Vector v) {
	top.SetState(v);
    }

	
    public static void main(String[] args) {
	GmpTest t=new GmpTest();
    }



}
