
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;


import JavaGroups.*;


public class Draw implements Runnable, MouseMotionListener, WindowListener, ActionListener {
    private Graphics               graphics=null;
    private Frame                  mainFrame=null;
    private Panel                  panel=null, sub_panel=null;
    private ByteArrayOutputStream  out=new ByteArrayOutputStream();
    private DataOutputStream       outstream;
    private DataInputStream        instream;
    private Random                 random=new Random(System.currentTimeMillis());
    private Button                 clear_button, leave_button;
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);
    private String                 groupname="DrawGroup";
    private Channel                channel=null;
    private Thread                 receiver=null;
    private int                    member_size=1;
    private int                    red=0, green=0, blue=0;
    private Color                  default_color=null;

 
    public Draw(ChannelFactory factory, String props) throws Exception {
	channel=factory.CreateChannel(props);
    }


    public static void main(String[] args) {
	Draw             draw=null;
	ChannelFactory   factory=new JChannelFactory();
	String           arg, next_arg;
	String           logfile=null;
	String           props=null;
    

	try {
	    
	    //props="UDP:DELAY(trace=true;in_delay=100;out_delay=50):PING:FD:GMS";
	    props="UDP:FD:GMS:STATE_TRANSFER:QUEUE";

	    for(int i=0; i < args.length; i++) {
		arg=args[i];
		if(arg.equals("-type")) {
		    next_arg=args[++i];
		    if(next_arg.equals("ens")) {
			props=null;
			factory=new EnsChannelFactory();
			continue;
		    }
		    else if(next_arg.equals("ibus")) {
			factory=(ChannelFactory)Class.forName("JavaGroups.IbusChannelFactory").newInstance();
			continue;
		    }
		}
		else if(arg.equals("-ucast"))
		    props="UDP(ip_mcast=false):GMS(gossip_host=" + args[++i] + 
			";gossip_port=" + new Integer(args[++i]).intValue() +")";
		else if(arg.equals("-help")) {
		    System.out.println("Draw [-type ens | ibus ] " + 
				       "[-ucast <gossip host> <gossip port>");
		    return;
		}
	    }


	}
	catch(Exception e) {
	    System.out.println("Creation of channel factory failed, reason is: " + e);
	    return;
	}
	try {
	    draw=new Draw(factory, props);
	    draw.go();
	}
	catch(Exception e) {
	    System.err.println(e);
	    System.exit(0);
	}
    }




    private void SelectColor() {
	red=(Math.abs(random.nextInt()) % 255);
	green=(Math.abs(random.nextInt()) % 255);
	blue=(Math.abs(random.nextInt()) % 255);
	default_color=new Color(red, green, blue);
    }


	
    public void go() {
	try {
	    channel.Connect(groupname);
	    receiver=new Thread(this, "DrawThread");
	    receiver.start();
	    mainFrame=new Frame();
	    panel=new Panel();
	    sub_panel=new Panel();
	    mainFrame.setSize(200,200);
	    mainFrame.add("Center", panel);
	    clear_button=new Button("Clear");
	    clear_button.setFont(default_font);
	    clear_button.addActionListener(this);
	    leave_button=new Button("Leave & Exit");
	    leave_button.setFont(default_font);
	    leave_button.addActionListener(this);
	    sub_panel.add("South", clear_button);
	    sub_panel.add("South", leave_button);
	    mainFrame.add("South", sub_panel);
	    mainFrame.addWindowListener(this);
	    panel.addMouseMotionListener(this);
	    mainFrame.setVisible(true);
	    mainFrame.setTitle(member_size + " mbrs");
	    graphics=panel.getGraphics();
	    SelectColor();
	    graphics.setColor(default_color);
	    mainFrame.setBackground(Color.white);
	    clear_button.setForeground(Color.blue);
	    leave_button.setForeground(Color.blue);
	}
	catch(Exception e) {
	    System.err.println(e);
	    return;
	}
    }


    public void run() {
	Object    tmp;
	Message   msg=null;
 	int       my_x=10, my_y=10, r=0, g=0, b=0;
		
	boolean  fl=true;

	while(fl) {
	    my_x=10; 
	    my_y=10;
	    try {
		tmp=channel.Receive(0);
		
		if(tmp == null) continue;
		
		if(tmp instanceof View) {
		    View v=(View)tmp;
		    member_size=v.Size();
		    if(mainFrame != null)
			mainFrame.setTitle(member_size + " mbrs");
		    continue;
		}
		if(!(tmp instanceof Message))
		    continue;

		msg=(Message)tmp;

		instream=new DataInputStream(new ByteArrayInputStream(msg.GetBuffer()));
		r=instream.readInt();   // red
		if(r == -13) {
		    ClearPanel();
		    continue;
		}
		g=instream.readInt();   // green
		b=instream.readInt();   // blue
		my_x=instream.readInt();
		my_y=instream.readInt();
	    }
	    catch(ChannelNotConnected not) {
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	    if(graphics != null) {
		graphics.setColor(new Color(r, g, b));
		graphics.fillOval(my_x, my_y, 10, 10);
		graphics.setColor(default_color);
	    }
	}
    }


    /* --------------- Callbacks --------------- */


    public void mouseMoved(MouseEvent e) {}

    public void mouseDragged(MouseEvent e) {
	int          tmp[]=new int[1], x, y; 

	tmp[0]=0;
	x=e.getX();
	y=e.getY();

	graphics.fillOval(x, y, 10, 10);

	try {
	    out.reset();
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(red);
	    outstream.writeInt(green);
	    outstream.writeInt(blue);
	    outstream.writeInt(x);
	    outstream.writeInt(y);
	    channel.Send(new Message(null, null, out.toByteArray()));
	    out.reset();	
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }


    public void ClearPanel() {
	Rectangle  bounds=null;
	if(panel == null || graphics == null)
	    return;

	bounds=panel.getBounds();
	graphics.clearRect(0, 0, bounds.width, bounds.height);	
    }


    public void SendClearPanelMsg() {
	int      tmp[]=new int[1]; tmp[0]=0;

	try {
	    out.reset();
	    outstream=new DataOutputStream(out);
	    outstream.writeInt(-13);
	    channel.Send(new Message(null, null, out.toByteArray()));
	    outstream.flush();
	}
	catch(Exception ex) {
	    System.err.println(ex);
	}
    }




    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	System.exit(0);  // exit the dirty way ...
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}


    public void actionPerformed(ActionEvent e) {
	String     command=e.getActionCommand();	
	if(command == "Clear")
	    SendClearPanelMsg();
	else if(command == "Leave & Exit") {
	    try {
		channel.Disconnect();
		channel.Close();
	    }
	    catch(Exception ex) {
		System.err.println(ex);
	    }
	    mainFrame.setVisible(false);
	    System.exit(0);
	}
	else
	    System.out.println("Unknown action");
    }




}

