
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import JavaGroups.*;


public class DistributedHashtableDemo extends Frame implements WindowListener, ActionListener, 
					  DistributedHashtable.Notification {
    private final String          groupname="HashDemo";
    private DistributedHashtable  h=null;
    private Button                get=new Button("Get"), set=new Button("Set");
    private Button                quit=new Button("Quit"), get_all=new Button("All");
    private Button                delete=new Button("Delete");
    private Label                 stock=new Label("Key"), value=new Label("Value");
    private Label                 err_msg=new Label("Error");
    private TextField             stock_field=new TextField(), value_field=new TextField();
    private java.awt.List         listbox=new java.awt.List();
    private final Font            default_font=new Font("Helvetica",Font.PLAIN,12);


    public DistributedHashtableDemo() {
	super();
	addWindowListener(this);
    }

    private void ShowMsg(String msg) {
	err_msg.setText(msg);
	err_msg.setVisible(true);
    }

    private void ClearMsg() {err_msg.setVisible(false);}


    private void RemoveItem() {
	int index=listbox.getSelectedIndex();
	if(index == -1) {
	    ShowMsg("No item selected in listbox to be deleted !");
	    return;
	}
	String s=listbox.getSelectedItem();
	String key=s.substring(0, s.indexOf(':', 0));
	if(key != null)
	    h.remove(key);
    }

    private void ShowAll() {
	listbox.removeAll();
	if(h.size() == 0) {
	    return;
	}
	ClearMsg();
	listbox.removeAll();
	String key;
	Float val;
	
	for(Enumeration en=h.keys(); en.hasMoreElements();) {
	    key=(String)en.nextElement();
	    val=(Float)h.get(key);
	    if(val == null)
		continue;
	    listbox.add(key + ": " + val.toString());
	}	
    }





    public void Start(ChannelFactory factory) {
	h=new DistributedHashtable(groupname, factory);
	h.AddNotifier(this);

	setLayout(null);
	setSize(400, 300);
	setFont(default_font);
	
	stock.setBounds(new Rectangle(10, 30, 60, 30));
	value.setBounds(new Rectangle(10, 60, 60, 30));
	stock_field.setBounds(new Rectangle(100, 30, 100, 30));
	value_field.setBounds(new Rectangle(100, 60, 100, 30));
	listbox.setBounds(new Rectangle(210, 30, 150, 160));
	err_msg.setBounds(new Rectangle(10, 200, 350, 30));
	err_msg.setFont(new Font("Helvetica",Font.ITALIC,12));
	err_msg.setForeground(Color.red);
	err_msg.setVisible(false);
	get.setBounds(new Rectangle(10, 250, 60, 30));
	set.setBounds(new Rectangle(80, 250, 60, 30));
	quit.setBounds(new Rectangle(150, 250, 60, 30));
	get_all.setBounds(new Rectangle(220, 250, 60, 30));
	delete.setBounds(new Rectangle(290, 250, 60, 30));

	get.addActionListener(this);
	set.addActionListener(this);
	quit.addActionListener(this);
	get_all.addActionListener(this);
	delete.addActionListener(this);

	add(stock); add(value);
	add(stock_field); add(value_field);
	add(err_msg);
	add(get); add(set); add(quit); add(get_all); add(delete);
	add(listbox);
	setTitle("DistributedHashtable Demo");
	ShowAll();
	setVisible(true);
    }



    public void windowActivated(WindowEvent e)   {}
    public void windowClosed(WindowEvent e)      {}
    public void windowClosing(WindowEvent e)     {System.exit(0);}
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e)   {}
    public void windowOpened(WindowEvent e)      {}


    public void actionPerformed(ActionEvent e) {
	String command=e.getActionCommand();
	try {
	    if(command == "Get") {
		String stock_name=stock_field.getText();
		if(stock_name == null || stock_name.length() == 0) {
		    ShowMsg("Key is empty !");
		    return;
		}
		ShowMsg("Looking up value for " + stock_name + ":");
		Float val=(Float)h.get(stock_name);
		if(val != null) {
		    value_field.setText(val.toString());
		    ClearMsg();
		}
		else {
		    value_field.setText("");
		    ShowMsg("Value for " + stock_name + " not found");
		}
	    }
	    else if(command == "Set") {
		String stock_name=stock_field.getText();
		String stock_val=value_field.getText();
		if(stock_name == null || stock_val == null || stock_name.length() == 0 ||
		   stock_val.length() == 0) {
		    ShowMsg("Both key and value have to be present to create a new entry");
		    return;
		}
		Float val=new Float(stock_val);
		h.put(stock_name, val);
		ShowMsg("Key " + stock_name + " set to " + val);
	    }
	    else if(command == "All") {
		ShowAll();
	    }
	    else if(command == "Quit") {
		setVisible(false);
		System.exit(0);
	    }
	    else if(command == "Delete")
		RemoveItem();
	    else
		System.out.println("Unknown action");
	}
	catch(Exception ex) {
	    value_field.setText("");
	    ShowMsg(ex.toString());
	}
    }



    public void EntrySet(Object key, Object value) {ShowAll();}
    public void EntryRemoved(Object key)           {ShowAll();}


    
    public static void main(String args[]) {
	DistributedHashtableDemo  client=new DistributedHashtableDemo();
	ChannelFactory            factory=new JChannelFactory();
	String                    properties="UDP:GMS", arg, next_arg;

	try {
	    for(int i=0; i < args.length; i++) {
		arg=args[i];
		if(arg.equals("-type")) {
		    next_arg=args[++i];
		    if(next_arg.equals("ens")) {
			factory=new EnsChannelFactory();
			properties=null;
			continue;
		    }
		    else if(next_arg.equals("ibus")) {
			factory=(ChannelFactory)Class.forName("JavaGroups.IbusChannelFactory").newInstance();
			properties=null;
			continue;
		    }
		}
		else if(arg.equals("-help")) {
		    System.out.println("DistributedHashtableDemo [-type ens|ibus ]");
		    return;
		}
	    }
	}
	catch(Exception e) {
	    System.out.println("DistributedHashtableDemo [-type ens|ibus]");
	    return;
	}
	client.Start(factory);
    }

	
}
