package JavaGroups;

import JavaGroups.Observer;

/**
   Class whose state is observed by Observers. An observer can attach itself to be notified
   when the state of the subject is modified, and it can also detach itself. The subject keeps
   a list of observers: whenever the state is modified in a subject, <code>Notify</code> should
   be called. This will in turn call <code>Update</code> in all observers. The observers may then
   access the subject to retrieve the state.
 */
public interface Subject {
    public void Attach(Observer o);
    public void Detach(Observer o);
    public void Notify();
}
