package JavaGroups.JavaStack;


import java.util.*;
import JavaGroups.*;





/**

 */
public class RpcProtocol extends MessageProtocol {
    final MethodLookup method_lookup_clos=new MethodLookupClos();


    public String GetName() {return "RpcProtocol";}



    public RspList CallRemoteMethods(Vector dests, String method_name, int mode, long timeout) {
	MethodCall method_call=new MethodCall(method_name);
	return CallRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList CallRemoteMethods(Vector dests, String method_name, Object arg1, 
				     int mode, long timeout) {
	MethodCall method_call=new MethodCall(method_name, arg1);
	return CallRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList CallRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2, 
				     int mode, long timeout) {
	MethodCall method_call=new MethodCall(method_name, arg1, arg2);
	return CallRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList CallRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2,
				     Object arg3, int mode, long timeout) {
	MethodCall method_call=new MethodCall(method_name, arg1, arg2, arg3);
	return CallRemoteMethods(dests, method_call, mode, timeout);
    }



    public RspList CallRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
	byte[]   buf=null;
	Message  msg=null;

	try {
	    buf=Util.ObjectToByteBuffer(method_call);
	}
	catch(Exception e) {
	    System.err.println("RpcProtocol.CallRemoteMethods(): " + e);
	    return null;
	}

	msg=new Message(null, null, buf);
	return CastMessage(dests, msg, mode, timeout);
    }







    public Object CallRemoteMethod(Object dest, String method_name, int mode, long timeout) 
	throws Timeout, Suspected {
	MethodCall method_call=new MethodCall(method_name);
	return CallRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object CallRemoteMethod(Object dest, String method_name, Object arg1, int mode, long timeout) 
	throws Timeout, Suspected {
	MethodCall method_call=new MethodCall(method_name, arg1);
	return CallRemoteMethod(dest, method_call, mode, timeout);
    }
    
    public Object CallRemoteMethod(Object dest, String method_name, Object arg1, Object arg2, 
				int mode, long timeout) throws Timeout, Suspected {
	MethodCall method_call=new MethodCall(method_name, arg1, arg2);
	return CallRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object CallRemoteMethod(Object dest, String method_name, Object arg1, Object arg2, 
				   Object arg3, int mode, long timeout) throws Timeout, Suspected {
	MethodCall method_call=new MethodCall(method_name, arg1, arg2, arg3);
	return CallRemoteMethod(dest, method_call, mode, timeout);
    }


    public Object CallRemoteMethod(Object dest, MethodCall method_call, int mode, long timeout) 
	throws Timeout, Suspected {
	byte[]   buf=null;
	Message  msg=null;

	try {
	    buf=Util.ObjectToByteBuffer(method_call);
	}
	catch(Exception e) {
	    System.err.println("RpcProtocol.CallRemoteMethod(): " + e);
	    return null;
	}

	msg=new Message(dest, null, buf);
	return SendMessage(msg, mode, timeout);
    }





    /**
       Message contains MethodCall. Execute it against *this* object and return result.
       Use MethodCall.Invoke() to do this. Return result.
     */
    public Object Handle(Message req) {
	Object      body=null, retval=null;
	MethodCall  method_call;

	if(req == null || req.GetBuffer() == null) {
	    System.err.println("RpcProtocol.Handle(): message or message buffer is null !");
	    return null;
	}

	try {
	    body=Util.ObjectFromByteBuffer(req.GetBuffer());
	}
	catch(Exception e) {
	    System.err.println("RpcProtocol.Handle(): " + e);
	    return null;
	}

	if(body == null || !(body instanceof MethodCall)) {
	    System.err.println("RpcProtocol.Handle(): message does not contain a MethodCall object !");
	    return null;
	}

	method_call=(MethodCall)body;
	retval=method_call.Invoke(this, method_lookup_clos);
	return retval;
    }



    /**
       Handle up event. Return false if it should not be passed up the stack.
     */
    public boolean HandleUpEvent(Event evt) {return true;}


    /**
       Handle down event. Return false if it should not be passed down the stack.
    */
    public boolean HandleDownEvent(Event evt) {return true;}



}
