package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.net.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



/**
 * Algorithm for this class:<p>
 * <li>Receive a UDP packet
 * <li>Call up_prot.Up() to pass it up to the next layer above us
 * Messages received by this thread flow up from the bottom to the top of the stack,
 * that is, towards the Transport object (and eventually towards the application).
 */

public class UdpReceiverThread extends Thread {    
    private UDP              udp_prot;
    private final int        RECEIVE_BUFFER_SIZE=65535;
    private DatagramSocket   sock=null;
    private boolean          loopback=true;
    private InternetAddress  local_addr=null;



    public UdpReceiverThread(UDP udp) {
	setName("UdpReceiverThread");
	udp_prot=udp;

	try {
	    sock=new DatagramSocket();
	    local_addr=new InternetAddress(InetAddress.getLocalHost(), sock.getLocalPort());
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public InternetAddress GetLocalAddress() {return local_addr;}


    public void Stop() {
	if(sock != null) {
	    sock.close();
	    sock=null;
	}
    }


    public void run() {
	ByteArrayInputStream inp_stream;
	ObjectInputStream    inp;
	Message              msg;
	DatagramPacket       packet;
	byte                 receive_buf[]=new byte[RECEIVE_BUFFER_SIZE];
	Protocol             up_prot;
	Object               src_addr, dest_addr;
	InternetAddress      src, dest;

	loopback=udp_prot.GetLoopback();
	up_prot=udp_prot.GetUpProtocol();
	
	while(true) {		
	    try {
		packet=new DatagramPacket(receive_buf, receive_buf.length);
		sock.receive(packet);
		inp_stream=new ByteArrayInputStream(packet.getData());
		inp=new ObjectInputStream(inp_stream);
		msg=(Message)inp.readObject();

		if(up_prot == null) {
		    System.err.println("UDP protocol: layer above me is null; discarding msg !");
		    continue;
		}

		/* Discard packets where source and destination address are the same */
		if(loopback == false) {
		    src_addr=msg.GetSrc();
		    dest_addr=msg.GetDest();

		    if(src_addr == null || dest_addr == null)
			continue;
		    if(!(src_addr instanceof Oid) || !(dest_addr instanceof Oid)) {
			System.out.println("UdpReceiverThread.run(): checking loopback: " +
					   "source or dest addresses are not of type Oid !");
			continue;
		    }

		    src=(InternetAddress)((Oid)src_addr).GetAddress();
		    dest=(InternetAddress)((Oid)dest_addr).GetAddress();

		    if(src != null && dest != null) {
			if(src.equals(dest)) {
			    System.out.println("UdpReceiverThread.run(): discarded loopback msg");
			    continue;
			}
		    }		    
		}
		up_prot.Up(msg);
	    }
	    catch(Exception e) {
		// System.err.println("UdpReceiverThread: problem receiving packet: " + e);
	    }	    
	}
    }


}
