package JavaGroups.JavaStack.Protocols;

import java.util.Properties;
import java.util.Random;
import JavaGroups.*;
import JavaGroups.JavaStack.*;

/**
   Layer that randomly discards messages sent down a stack.
 */

public class DISCARD extends Protocol {
    boolean   trace=false;
    Random    r=new Random(322649);  // n=(Math.abs(rand.nextInt()) % 10)+5;
    int       rand=10;
    int       count=0;
    int       discard=(Math.abs(r.nextInt()) % rand) + 1;


    public String  GetName() {return "DISCARD";}



    public void SetProperties(Properties props) {
	String     str;

	this.props=props;

	str=props.getProperty("trace");
	if(str != null)
	    trace=new Boolean(str).booleanValue();

	str=props.getProperty("random"); // 0 means discard every msg, 1 discard every second etc.
	if(str != null)
	    rand=new Integer(str).intValue();
    }



    public void Down(Event evt) {
	Message msg;

	if(evt.GetType() == Event.MSG) {
	    if(count++ >= discard) {
		
		if(trace) {
		    System.out.println("DISCARD.Down(): count=" + (count-1) + ", discard=" + discard + 
				       ": discarding message");
		}

		count=0;
		discard=(Math.abs(r.nextInt()) % rand) + 1;
		return;
	    }
	    

	}

	PassDown(evt);  // Pass on to the layer below us
    }


}
