package JavaGroups.JavaStack.Protocols;

import java.util.*;
import JavaGroups.channel.*;
import JavaGroups.JavaStack.*;

public class DEBUG implements Protocol {
    private Protocol            down_prot=null;
    private Protocol            up_prot=null;
    private Queue               up_queue=new Queue();
    private Queue               down_queue=new Queue();
    private DebugDownThread     down_thread=null;
    private DebugUpThread       up_thread=null;
    private Properties          properties=null;
    private long                down_sleep_time=1000; // ms
    private long                up_sleep_time=1000; // ms


    public DEBUG() {}


    public Properties    GetProperties()       {return properties;}
    public String        GetName()             {return "DEBUG";}
    public Protocol      GetUpProtocol()       {return up_prot;}
    public Protocol      GetDownProtocol()     {return down_prot;}
    public Queue         GetDownQueue()        {return down_queue;}
    public Queue         GetUpQueue()          {return up_queue;}


    private class DebugUpThread extends Thread {
	Message msg;

	public void run() {
	    while(true) {
		try {
		    System.out.println("Size of up msg queue: " + up_queue.Size());
		    msg=(Message)up_queue.Remove();
		    if(up_prot != null)
			up_prot.Up(msg);
		    sleep(up_sleep_time);
		}
		catch(Exception e) {
		    System.err.println(e);
		}		    
	    }
	}
    }
    

    private class DebugDownThread extends Thread {
	Message msg;

	public void run() {
	    while(true) {
		try {
		    System.out.println("Size of down msg queue: " + down_queue.Size());
		    msg=(Message)down_queue.Remove();
		    if(down_prot != null)
			down_prot.Down(msg);
		    sleep(down_sleep_time);
		}
		catch(Exception e) {
		    System.err.println(e);
		}		
	    }    
	}
    }



    public void SetProperties(Properties props) {
	String sl=props.getProperty("down_sleep_time");
	if(sl != null)
	    down_sleep_time=Long.parseLong(sl);
	sl=props.getProperty("up_sleep_time");
	if(sl != null)
	    up_sleep_time=Long.parseLong(sl);
    }

    public void SetUpProtocol(Protocol up_protocol) {
	up_prot=up_protocol;
    }

    public void SetDownProtocol(Protocol down_protocol) {
	down_prot=down_protocol;
    }



    public void Up(Message msg) {
	try {
	    up_queue.Add(msg);
	}
	catch(Exception e) {
	    System.err.println(e);
	}	
    }


    public void Down(Message msg) throws Exception {
	down_queue.Add(msg);
    }



    public void StartWork() {
	down_thread=new DebugDownThread();
	up_thread=new DebugUpThread();
	up_thread.start();
	down_thread.start();	
    }

    public void StopWork() {
	if(up_thread != null) {
	    up_thread.stop();
	    up_thread=null;
	}
	if(down_thread != null) {
	    down_thread.stop();
	    down_thread=null;
	}	
    }

    public void SetProtocolStack(ProtocolStack stack) {}


    public String toString() {
	return "Protocol DEBUG (down_sleep_time=" + down_sleep_time +
	    ";up_sleep_time=" + up_sleep_time + ")";
    }


}
