package JavaGroups.JavaStack.Protocols;

import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;

public class RpcParticipantGmsImpl extends RpcGmsImpl {
    private static RpcParticipantGmsImpl  impl=null;
    private        boolean                leaving=false;


    private RpcParticipantGmsImpl() {}

    public static RpcParticipantGmsImpl CreateInstance(RpcGMS gms) {
	if(impl == null)
	    impl=new RpcParticipantGmsImpl();
	impl.gms=gms;
	impl.leaving=false;
	return impl;
    }





    public void Join(Address mbr) {
	WrongMethod("Join");
    }


    /**
       Loop: determine coord. If coord is me --> HandleLeave(). Else send HandleLeave() to coord until
       success.
     */
    public void Leave(Address mbr) {
	int       num_tries=3;
	Address   coord;
	Boolean   retval=null;

	if(mbr.equals(gms.local_addr))
	    leaving=true;

	while((coord=gms.DetermineCoordinator()) != null && num_tries-- > 0) {
	    if(gms.local_addr.equals(coord)) {  // I'm the coordinator
		gms.SetImpl(RpcCoordGmsImpl.CreateInstance(gms));
		gms.HandleLeave(mbr);
		return;
	    }
	    try {
		retval=(Boolean)gms.CallRemoteMethod(coord, "HandleLeave", mbr, 
						     MessageProtocol.FIRST, 0);
		if(retval != null && retval.booleanValue() == true)
		    break;
		else {
		    Util.Sleep(gms.leave_timeout);
		    continue;
		}
	    }
	    catch(Exception e) {
		System.err.println("RpcParticipantGmsImpl.Leave(): " + e);
		Util.Sleep(gms.leave_timeout);
		continue;
	    }
	}
	gms.SetImpl(RpcClientGmsImpl.CreateInstance(gms)); // become client
    }




    public void Suspect(Address mbr) {
	HandleSuspect(mbr);
    }



    public void Merge(Vector new_mbrs) {
	HandleMerge(new_mbrs, null, 0);
    }


    public JoinRsp HandleJoin(Address mbr) {
	WrongMethod("HandleJoin");
	return new JoinRsp(JoinRsp.JOIN_FAILED);
    }


    public boolean HandleLeave(Address mbr) {
	WrongMethod("HandleLeave");
	return false;
    }


    public void HandleViewChange(ViewId new_view, Vector mbrs) {
	if(leaving) {
	    System.err.println("RpcParticipantGmsImpl.HandleViewChange(): I won't install new view " +
			       new_view + " as I'm leaving");
	    return;
	}
	gms.InstallView(new_view, mbrs);
    }


    public void HandleMerge(Vector new_mbrs, Vector suspects, long other_ltime) {
	Object coord;

	synchronized(gms.view_mutex) {
	    gms.ltime=Math.max(gms.ltime, other_ltime) + 1;
	    gms.members.Merge(new_mbrs, suspects);
	    gms.members.Sort();
	    coord=gms.DetermineCoordinator();
	    if(coord != null && coord.equals(gms.local_addr)) {        // I'm the new coordinator
		gms.SetImpl(RpcCoordGmsImpl.CreateInstance(gms));
		gms.CastView(null);
	    }
	}
    }


    public void HandleSuspect(Address mbr) {
	Object coord=gms.DetermineCoordinator();

	System.out.println("Part.HandleSuspect(" + mbr + "), members are " + gms.members +
			   ", coord=" + coord);
	
	synchronized(gms.view_mutex) {
	    if(coord != null && coord.equals(mbr)) {                   // coordinator is suspected
		gms.members.Remove(mbr);
		coord=gms.DetermineCoordinator();
		if(coord != null && coord.equals(gms.local_addr)) {    // I'm the new coordinator
		    gms.SetImpl(RpcCoordGmsImpl.CreateInstance(gms));
		    gms.CastView(null);
		}
	    }
	}
    }



    
}
