/*
 * Decompiled with CFR 0.152.
 */
import JavaGroups.FailureDetectorListener;
import JavaGroups.OID;
import JavaGroups.UnicastAddress;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class Topology
extends Frame
implements WindowListener,
FailureDetectorListener {
    private Vector members;
    private Graphics g;
    private Font font;
    private FontMetrics fm;
    private Color node_color = new Color(250, 220, 100);
    private boolean coordinator = false;
    private OID curr_hb;
    private OID current_check;
    private final int NormalStyle = 0;
    private final int CheckStyle = 1;
    private final int HeartbeatStyle = 2;

    public Topology() {
        this.addWindowListener(this);
        this.g = this.getGraphics();
        this.fm = this.getFontMetrics(new Font("TimesRoman", 1, 12));
        this.font = new Font("TimesRoman", 1, 12);
    }

    public void SetState(Vector mbrs) {
        this.members = mbrs;
        this.repaint();
    }

    public void AddNode(UnicastAddress member) {
        this.members.addElement(member);
        this.repaint();
    }

    public void RemoveNode(UnicastAddress member) {
        this.members.removeElement(member);
        this.repaint();
    }

    public void DrawNode(Graphics g, int x, int y, String label, int style) {
        Color old = g.getColor();
        int width = this.fm.stringWidth(label) + 10;
        int height = this.fm.getHeight() + 5;
        switch (style) {
            case 2: {
                g.setColor(Color.green);
                break;
            }
            default: {
                g.setColor(this.node_color);
            }
        }
        g.fillRect(x, y, width, height);
        g.setColor(old);
        g.drawString(label, x + 5, y + 15);
        g.drawRoundRect(x - 1, y - 1, width + 1, height + 1, 10, 10);
        if (style == 1) {
            g.drawRoundRect(x - 2, y - 2, width + 2, height + 2, 10, 10);
            g.drawRoundRect(x - 3, y - 3, width + 3, height + 3, 10, 10);
        }
    }

    public void DrawTopology(Graphics g) {
        int x = 20;
        int y = 50;
        Dimension box = this.getSize();
        Color old = g.getColor();
        if (this.coordinator) {
            g.setColor(Color.cyan);
            g.fillRect(11, 31, box.width - 21, box.height - 61);
            g.setColor(old);
        }
        g.drawRect(10, 30, box.width - 20, box.height - 60);
        g.setFont(this.font);
        int i = 0;
        while (i < this.members.size()) {
            OID tmp_oid = ((UnicastAddress)this.members.elementAt(i)).GetOid();
            String label = tmp_oid.toString();
            if (this.current_check != null && this.current_check == tmp_oid) {
                this.DrawNode(g, x, y, label, 1);
            } else if (this.curr_hb != null && this.curr_hb == tmp_oid) {
                this.DrawNode(g, x, y, label, 2);
            } else {
                this.DrawNode(g, x, y, label, 0);
            }
            y += 50;
            ++i;
        }
    }

    public void paint(Graphics g) {
        this.DrawTopology(g);
    }

    public void ReceivedHeartbeat(OID obj) {
        this.curr_hb = obj;
        this.repaint();
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.curr_hb = null;
        this.repaint();
    }

    public void CoordinatorChosen() {
        this.coordinator = true;
        this.repaint();
    }

    public void CheckForCoord(OID obj) {
        this.current_check = obj;
        this.repaint();
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.current_check = null;
        this.repaint();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

