/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Address;
import JavaGroups.Configurator;
import JavaGroups.Message;
import JavaGroups.MessageCorrelator;
import JavaGroups.MessageListener;
import JavaGroups.MultipleAddress;
import JavaGroups.Protocol;
import JavaGroups.Protocols.UDP;
import JavaGroups.RpcMessage;
import JavaGroups.UnicastAddress;
import java.util.Properties;
import java.util.Vector;

public class Transport
implements Protocol {
    private static long current_msg_id = 1L;
    private MessageListener listener;
    private Protocol protocol_stack;
    private Configurator configurator = new Configurator();
    private MessageCorrelator correlator = new MessageCorrelator();

    public Transport(String configuration) throws Exception {
        this.protocol_stack = configuration != null && configuration.length() > 0 ? this.configurator.SetupProtocolStack(configuration) : this.configurator.SetupProtocolStack("UDP");
        this.protocol_stack.SetReceiveProtocol(this);
    }

    public Transport() throws Exception {
        this.protocol_stack = this.configurator.SetupProtocolStack("UDP");
        this.protocol_stack.SetReceiveProtocol(this);
    }

    public int GetInPort() {
        UDP u = (UDP)this.FindProtocol("UDP");
        if (u == null) {
            return -1;
        }
        return u.GetInPort();
    }

    public void SetMessageListener(MessageListener l) {
        this.listener = l;
    }

    private void AssignId(Message msg) {
        long tmp_id = msg.GetMessageId();
        if (tmp_id <= 0L) {
            tmp_id = Message.GetNextId();
            msg.SetMessageId(tmp_id);
        }
    }

    Vector CheckMultipleDestinations(Address addr) {
        if (addr != null && addr instanceof MultipleAddress) {
            return ((MultipleAddress)addr).GetAddresses();
        }
        return null;
    }

    public synchronized void Send(Message msg) throws Exception {
        Vector mult = this.CheckMultipleDestinations(msg.GetDestinationAddress());
        if (mult != null) {
            int i = 0;
            while (i < mult.size()) {
                Address dest = (Address)mult.elementAt(i);
                Message m = (Message)msg.clone();
                m.SetDestinationAddress((Address)dest.clone());
                this.Send(m);
                ++i;
            }
            return;
        }
        if (msg.GetSourceAddress() == null) {
            msg.SetSourceAddress(new UnicastAddress());
        }
        this.protocol_stack.Send(msg);
    }

    public Message SendMsg(Message msg, long timeout) throws Exception {
        Message retval = null;
        this.correlator.AddRequest(msg);
        this.Send(msg);
        retval = this.correlator.GetResponse(msg.GetMessageId(), timeout);
        return retval;
    }

    public Message SendMsg(Message msg) throws Exception {
        return this.SendMsg(msg, 0L);
    }

    public Vector SendMsgGetAll(Message msg, int expected_responses, long timeout) throws Exception {
        this.correlator.AddRequest(msg);
        this.Send(msg);
        return this.correlator.GetResponses(msg.GetMessageId(), expected_responses, timeout);
    }

    public Vector SendMsgGetAll(Message msg, int expected_responses) throws Exception {
        return this.SendMsgGetAll(msg, expected_responses, -1L);
    }

    public Object SendRpc(RpcMessage msg, long timeout) throws Exception {
        Message retval = null;
        Object ret = null;
        msg.SetOneway(false);
        this.correlator.AddRequest(msg);
        this.Send(msg);
        retval = this.correlator.GetResponse(msg.GetMessageId(), timeout);
        return retval == null ? null : retval.GetObject();
    }

    public Object SendRpc(RpcMessage msg) throws Exception {
        return this.SendRpc(msg, 0L);
    }

    public Vector SendRpcGetAll(RpcMessage msg, int exp_responses, long timeout) throws Exception {
        Vector<Object> retval = new Vector<Object>();
        msg.SetOneway(false);
        this.correlator.AddRequest(msg);
        this.Send(msg);
        Vector tmp = this.correlator.GetResponses(msg.GetMessageId(), exp_responses, timeout);
        int i = 0;
        while (i < tmp.size()) {
            Object obj = ((Message)tmp.elementAt(i)).GetObject();
            if (obj != null) {
                retval.addElement(obj);
            }
            ++i;
        }
        return retval;
    }

    public Vector SendRpcGetAll(RpcMessage msg, int exp_responses) throws Exception {
        return this.SendRpcGetAll(msg, exp_responses, 0L);
    }

    public Protocol FindProtocol(String name) {
        if (this.protocol_stack != null) {
            return this.configurator.FindProtocol(this.protocol_stack, name);
        }
        return null;
    }

    public void SetProperties(Properties props) {
    }

    public Properties GetProperties() {
        return null;
    }

    public String GetName() {
        return "Transport";
    }

    public Protocol GetReceiveProtocol() {
        return null;
    }

    public Protocol GetSendProtocol() {
        return null;
    }

    public void SetReceiveProtocol(Protocol receiver_prot) {
    }

    public void SetSendProtocol(Protocol send_prot) {
    }

    public void Receive(Message msg) {
        try {
            if (msg.IsResponse() && this.correlator.AddResponse(msg)) {
                return;
            }
            if (this.listener != null) {
                this.listener.Receive(msg);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void StartWork() {
    }

    public void StopWork() {
    }
}

