/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RawMessage
implements Serializable,
Cloneable {
    private byte[] data;

    public RawMessage() {
    }

    public RawMessage(byte[] d) {
        this.data = d;
    }

    public RawMessage(Serializable msg) {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(msg);
            this.data = out_stream.toByteArray();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public long Size() {
        return this.data == null ? 0 : this.data.length;
    }

    public byte[] GetData() {
        return this.data;
    }

    public void SetData(byte[] new_data) {
        this.data = new_data;
    }

    public void SetObject(Serializable obj) {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            this.data = out_stream.toByteArray();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public Object ReadObject() {
        if (this.data == null) {
            return null;
        }
        Object ret = null;
        ByteArrayInputStream inp_stream = new ByteArrayInputStream(this.data);
        ObjectInputStream inp = null;
        try {
            inp = new ObjectInputStream(inp_stream);
            ret = inp.readObject();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return ret;
    }

    public Object GetObject() {
        return this.ReadObject();
    }

    public String ReadString() {
        if (this.data != null) {
            return (String)this.ReadObject();
        }
        return null;
    }

    public int ReadInt() {
        ByteArrayInputStream in_stream = new ByteArrayInputStream(this.data);
        DataInputStream inp = new DataInputStream(in_stream);
        int retval = 0;
        int initial_bytes = this.data.length;
        boolean bytes_read = false;
        try {
            retval = inp.readInt();
        }
        catch (Exception e) {
            System.err.println(e);
            return retval;
        }
        return retval;
    }

    public long ReadLong() {
        ByteArrayInputStream in_stream = new ByteArrayInputStream(this.data);
        DataInputStream inp = new DataInputStream(in_stream);
        long retval = 0L;
        int initial_bytes = this.data.length;
        boolean bytes_read = false;
        try {
            retval = inp.readLong();
        }
        catch (Exception e) {
            System.err.println(e);
            return retval;
        }
        return retval;
    }

    public void Prepend(byte[] new_data) {
        byte[] retval = null;
        boolean i = false;
        if (this.data == null) {
            this.data = new_data;
            return;
        }
        retval = new byte[new_data.length + this.data.length];
        System.arraycopy(new_data, 0, retval, 0, new_data.length);
        System.arraycopy(this.data, 0, retval, new_data.length, this.data.length);
        this.data = retval;
    }

    public void Prepend(int i) {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(out_stream);
        try {
            out.writeInt(i);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.Prepend(out_stream.toByteArray());
    }

    public void Prepend(long l) {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(out_stream);
        try {
            out.writeLong(l);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.Prepend(out_stream.toByteArray());
    }

    public void Prepend(Serializable obj) {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            this.Prepend(out_stream.toByteArray());
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void Append(byte[] new_data) {
        byte[] retval = null;
        boolean i = false;
        if (this.data == null) {
            this.data = new_data;
            return;
        }
        retval = new byte[new_data.length + this.data.length];
        System.arraycopy(this.data, 0, retval, 0, this.data.length);
        System.arraycopy(new_data, 0, retval, this.data.length, new_data.length);
        this.data = retval;
    }

    public void Append(int i) {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(out_stream);
        try {
            out.writeInt(i);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.Append(out_stream.toByteArray());
    }

    public void Append(long l) {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(out_stream);
        try {
            out.writeLong(l);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.Append(out_stream.toByteArray());
    }

    public void Append(Serializable obj) {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            this.Append(out_stream.toByteArray());
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void RemoveLeft(int num_bytes) throws Exception {
        if (this.data == null) {
            System.err.println("RawMessage.RemoveLeft(): data is null !");
            return;
        }
        int new_data_len = this.data.length - num_bytes;
        if (new_data_len < 0) {
            throw new Exception("RawMessage.RemoveLeft(): new data size would be " + new_data_len + " if removing " + num_bytes + " from it ");
        }
        if (new_data_len == 0) {
            this.data = null;
            return;
        }
        byte[] new_data = new byte[new_data_len];
        System.arraycopy(this.data, num_bytes, new_data, 0, new_data_len);
        this.data = new_data;
    }

    public int RemoveInt() throws Exception {
        ByteArrayInputStream in_stream = new ByteArrayInputStream(this.data);
        DataInputStream inp = new DataInputStream(in_stream);
        int retval = 0;
        int initial_bytes = this.data.length;
        int bytes_read = 0;
        retval = inp.readInt();
        bytes_read = initial_bytes - in_stream.available();
        this.RemoveLeft(bytes_read);
        return retval;
    }

    public long RemoveLong() throws Exception {
        ByteArrayInputStream in_stream = new ByteArrayInputStream(this.data);
        DataInputStream inp = new DataInputStream(in_stream);
        long retval = 0L;
        int initial_bytes = this.data.length;
        int bytes_read = 0;
        retval = inp.readLong();
        bytes_read = initial_bytes - in_stream.available();
        this.RemoveLeft(bytes_read);
        return retval;
    }

    public Object RemoveObject() throws Exception {
        ByteArrayInputStream in_stream = new ByteArrayInputStream(this.data);
        ObjectInputStream inp = new ObjectInputStream(in_stream);
        Object retval = null;
        int initial_bytes = this.data.length;
        int bytes_read = 0;
        retval = inp.readObject();
        bytes_read = initial_bytes - in_stream.available();
        this.RemoveLeft(bytes_read);
        return retval;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.data != null) {
            int i = 0;
            while (i < this.data.length) {
                ret.append((char)this.data[i]);
                ++i;
            }
        }
        return ret.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static void main(String[] args) {
        RawMessage msg = new RawMessage();
        try {
            msg.Append((Serializable)((Object)"Hello world"));
            msg.Append((Serializable)((Object)" from Bela"));
            msg.Prepend((Serializable)((Object)"Msg from Ralph: "));
            msg.Prepend(322649);
            msg.Prepend(1234567890L);
            long ll = msg.RemoveLong();
            System.out.println(ll);
            int l = msg.RemoveInt();
            System.out.println(l);
            String s = (String)msg.RemoveObject();
            System.out.println(s);
            s = (String)msg.RemoveObject();
            System.out.println(s);
            s = (String)msg.RemoveObject();
            System.out.println(s);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

