/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.Protocols;

import JavaGroups.Message;
import JavaGroups.MessageQueue;
import JavaGroups.Protocol;
import JavaGroups.Protocols.UDP;
import JavaGroups.UnicastAddress;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class UdpMcastReceiverThread
extends Thread {
    private UDP udp_prot;
    private boolean loopback = true;
    private InetAddress mcast_addr;
    private int mcast_port;

    public UdpMcastReceiverThread(UDP udp, InetAddress mcast, int p) {
        this.udp_prot = udp;
        this.mcast_addr = mcast;
        this.mcast_port = p;
    }

    public boolean GetMulticastLoopback() {
        return this.loopback;
    }

    public void SetMulticastLoopback(boolean f) {
        this.loopback = f;
    }

    public void run() {
        UnicastAddress local_addr;
        MulticastSocket sock = null;
        byte[] receive_buf = new byte[65000];
        int in_port = this.udp_prot.GetInPort();
        MessageQueue receive_queue = this.udp_prot.GetReceiveQueue();
        this.loopback = this.udp_prot.GetLoopback();
        try {
            local_addr = new UnicastAddress();
            sock = new MulticastSocket(this.mcast_port);
            sock.joinGroup(this.mcast_addr);
        }
        catch (Exception e) {
            System.err.println("UdpMcastReceiverThread: " + e);
            return;
        }
        block4: while (true) {
            try {
                while (true) {
                    Message msg;
                    Protocol receive_prot = this.udp_prot.GetReceiveProtocol();
                    Protocol send_prot = this.udp_prot.GetSendProtocol();
                    if (send_prot != null) {
                        msg = receive_queue.Remove();
                        if (receive_prot != null) {
                            receive_prot.Receive(msg);
                            continue;
                        }
                        System.err.println("UDP protocol: layer above is not available !");
                        continue;
                    }
                    DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
                    sock.receive(packet);
                    ByteArrayInputStream inp_stream = new ByteArrayInputStream(packet.getData());
                    ObjectInputStream inp = new ObjectInputStream(inp_stream);
                    msg = (Message)inp.readObject();
                    if (receive_prot == null) {
                        System.err.println("UDP protocol: no layer above us available !");
                        continue;
                    }
                    if (!this.loopback && local_addr.IsSameAddress(msg.GetSourceAddress())) continue block4;
                    receive_prot.Receive(msg);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }
}

