/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.Protocols;

import JavaGroups.Address;
import JavaGroups.Message;
import JavaGroups.MessageQueue;
import JavaGroups.Protocol;
import JavaGroups.Protocols.SlidingWindow;
import java.util.Hashtable;
import java.util.Properties;

public class FIFO
implements Protocol {
    private Protocol send_prot;
    private Protocol receive_prot;
    private MessageQueue receive_queue = new MessageQueue();
    private MessageQueue send_queue = new MessageQueue();
    private int size = 2048;
    private Hashtable senders = new Hashtable();
    private Properties properties;
    private boolean trace = false;
    private long lower_bound = 1L;

    public Properties GetProperties() {
        return this.properties;
    }

    public String GetName() {
        return "FIFO";
    }

    public Protocol GetReceiveProtocol() {
        return this.receive_prot;
    }

    public Protocol GetSendProtocol() {
        return this.send_prot;
    }

    public MessageQueue GetSendQueue() {
        return this.send_queue;
    }

    public MessageQueue GetReceiveQueue() {
        return this.receive_queue;
    }

    public void SetProperties(Properties props) {
        this.properties = props;
        String sl = props.getProperty("size");
        if (sl != null) {
            this.size = Integer.parseInt(sl);
        }
        if ((sl = props.getProperty("trace")) != null) {
            this.trace = new Boolean(sl);
        }
        if ((sl = props.getProperty("lower_bound")) != null) {
            this.lower_bound = Long.parseLong(sl);
        }
    }

    public void SetReceiveProtocol(Protocol receive_protocol) {
        this.receive_prot = receive_protocol;
    }

    public void SetSendProtocol(Protocol send_protocol) {
        this.send_prot = send_protocol;
    }

    public void Receive(Message msg) {
        SlidingWindow window = null;
        try {
            Hashtable hashtable = this.senders;
            synchronized (hashtable) {
                Message m;
                Address src_addr = msg.GetSourceAddress();
                if (src_addr == null) {
                    System.err.println("FIFO.Receive(): source address is null !");
                    Object var7_6 = null;
                    return;
                }
                if (this.senders.containsKey(src_addr)) {
                    window = (SlidingWindow)this.senders.get(src_addr);
                } else {
                    window = new SlidingWindow();
                    window.SetWindowSize(this.size);
                    window.SetTrace(this.trace);
                    window.SetLowerBound(this.lower_bound);
                    this.senders.put(src_addr, window);
                }
                window.Add(msg);
                while ((m = window.Remove()) != null) {
                    this.receive_prot.Receive(m);
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void Send(Message msg) throws Exception {
        this.send_prot.Send(msg);
    }

    public void StartWork() {
    }

    public void StopWork() {
    }

    public String toString() {
        return "Protocol FIFO";
    }
}

