/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.GMP;

import JavaGroups.Address;
import JavaGroups.Dispatcher;
import JavaGroups.FailureDetector;
import JavaGroups.FailureDetectorListener;
import JavaGroups.FdImpl;
import JavaGroups.GMP.GMP;
import JavaGroups.Group;
import JavaGroups.McastAddress;
import JavaGroups.MembershipListener;
import JavaGroups.MethodCall;
import JavaGroups.MultipleAddress;
import JavaGroups.OID;
import JavaGroups.RpcMessage;
import JavaGroups.Suspectable;
import JavaGroups.UnicastAddress;
import java.util.Vector;

public class GmpImpl
implements GMP,
Suspectable,
FailureDetector {
    private Vector listeners = new Vector();
    private Vector members = new Vector();
    private Dispatcher dispatcher;
    private OID my_oid;
    private final String mcast_addr = "230.10.10.10";
    private final int mcast_port = 10000;
    private final String mcast_groupname = "GMPs";
    private UnicastAddress my_addr;
    private final long MSG_TIMEOUT = 2000L;
    private Group my_group;
    private FdImpl failure_detector;

    private synchronized void AddMember(UnicastAddress new_member) {
        System.out.println("-----> AddMember: " + new_member);
        OID member_oid = new_member.GetOid();
        int i = 0;
        while (i < this.members.size()) {
            OID tmp_oid = ((UnicastAddress)this.members.elementAt(i)).GetOid();
            if (tmp_oid.IsSameObject(member_oid)) {
                System.err.println("GmpImpl.MemberJoined(): member " + new_member + " exists");
                return;
            }
            ++i;
        }
        this.members.addElement(new_member);
    }

    private synchronized void RemoveMember(UnicastAddress old_member) {
        OID member_oid = old_member.GetOid();
        int i = 0;
        while (i < this.members.size()) {
            OID tmp_oid = ((UnicastAddress)this.members.elementAt(i)).GetOid();
            if (tmp_oid.IsSameObject(member_oid)) {
                this.members.removeElement(this.members.elementAt(i));
                break;
            }
            ++i;
        }
    }

    public GmpImpl(Dispatcher d) {
        this.dispatcher = d;
        this.failure_detector = new FdImpl(this.dispatcher);
        this.failure_detector.FdAddSuspectableListener(this);
    }

    public void finalize() {
        if (this.dispatcher != null) {
            this.dispatcher.LeaveMulticastGroup("230.10.10.10", 10000);
        }
    }

    public synchronized void GmpStart() {
        try {
            this.my_oid = this.dispatcher.Register(this);
            this.my_addr = new UnicastAddress(this.my_oid);
            this.my_addr.SetPort(this.dispatcher.GetTransport().GetInPort());
            System.out.println("My address is " + this.my_addr);
            this.my_group = new Group("GMPs", new McastAddress("230.10.10.10", 10000, "GMPs"));
            this.my_group.AddMember(this.my_oid);
            this.dispatcher.Register(this.my_group);
            this.dispatcher.JoinMulticastGroup("230.10.10.10", 10000);
            RpcMessage get_state_msg = new RpcMessage((Address)new McastAddress("230.10.10.10", 10000, "GMPs"), (Address)this.my_addr, new MethodCall("GmpGetState", this.my_addr));
            Vector v = (Vector)this.dispatcher.SendRpc(get_state_msg, 2000L);
            if (v != null) {
                this.members = v;
            }
            if (this.members.size() > 0) {
                RpcMessage join_msg = new RpcMessage((Address)new MultipleAddress(this.members), (Address)this.my_addr, new MethodCall("GmpMemberJoined", this.my_addr));
                join_msg.SetOneway(true);
                this.dispatcher.Send(join_msg);
            }
            this.AddMember(this.my_addr);
            int i = 0;
            while (i < this.listeners.size()) {
                ((MembershipListener)this.listeners.elementAt(i)).SetState((Vector)this.members.clone());
                ++i;
            }
            this.failure_detector.FdSetAddress(this.my_oid);
            this.failure_detector.FdSetInitialMonitoredMembers((Vector)this.members.clone());
            this.failure_detector.FdStart();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        System.out.println("Initial size=" + this.members.size());
    }

    public void GmpAddListener(MembershipListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void GmpRemoveListener(MembershipListener l) {
        this.listeners.removeElement(l);
    }

    public Vector GmpGetState(UnicastAddress sender) {
        return this.members;
    }

    public void GmpMemberJoined(UnicastAddress new_member) {
        this.AddMember(new_member);
        System.out.println("------- MemberJoined(): I now have " + this.members.size() + " members");
        int i = 0;
        while (i < this.listeners.size()) {
            ((MembershipListener)this.listeners.elementAt(i)).MemberJoined(new_member);
            ++i;
        }
        this.failure_detector.FdAddMonitoredMember(new_member);
    }

    public void GmpMemberLeft(UnicastAddress old_member) {
        if (this.my_oid.equals(old_member.GetOid())) {
            System.out.println("Cannot remove myself !");
            return;
        }
        this.RemoveMember(old_member);
        System.out.println("------- MemberLeft(): I now have " + this.members.size() + " members");
        int i = 0;
        while (i < this.listeners.size()) {
            ((MembershipListener)this.listeners.elementAt(i)).MemberLeft(old_member);
            ++i;
        }
        this.failure_detector.FdRemoveMonitoredMember(old_member);
    }

    public void Suspect(Vector suspected_members) {
        int i = 0;
        while (i < suspected_members.size()) {
            this.Suspect((UnicastAddress)suspected_members.elementAt(i));
            ++i;
        }
    }

    public void Suspect(UnicastAddress suspected_member) {
        if (this.my_oid == suspected_member.GetOid()) {
            System.err.println("Hey, don't kill me: I'm still alive ! (" + this.my_oid + ")");
            return;
        }
        try {
            RpcMessage leave_msg = new RpcMessage((Address)new MultipleAddress(this.members), (Address)this.my_addr, new MethodCall("GmpMemberLeft", suspected_member));
            leave_msg.SetOneway(true);
            this.dispatcher.Send(leave_msg);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void FdAddFailureDetectorListener(FailureDetectorListener l) {
        this.failure_detector.FdAddFailureDetectorListener(l);
    }

    public void FdRemoveFailureDetectorListener(FailureDetectorListener l) {
        this.failure_detector.FdRemoveFailureDetectorListener(l);
    }

    public void FdSetInitialMonitoredMembers(Vector monitored_members) {
        this.failure_detector.FdSetInitialMonitoredMembers(monitored_members);
    }

    public void FdAddMonitoredMember(UnicastAddress new_member) {
        this.failure_detector.FdAddMonitoredMember(new_member);
    }

    public void FdRemoveMonitoredMember(UnicastAddress old_member) {
        this.failure_detector.FdRemoveMonitoredMember(old_member);
    }

    public void FdAddSuspectableListener(Suspectable l) {
        this.failure_detector.FdAddSuspectableListener(l);
    }

    public void FdSetInterval(long interval) {
        this.failure_detector.FdSetInterval(interval);
    }

    public void FdSetTimeout(long timeout) {
        this.failure_detector.FdSetTimeout(timeout);
    }

    public OID FdGetAddress() {
        return this.failure_detector.FdGetAddress();
    }

    public void FdSetAddress(OID address) {
        this.failure_detector.FdSetAddress(address);
    }

    public void FdStart() {
        this.failure_detector.FdStart();
    }

    public void FdStop() {
        this.failure_detector.FdStop();
    }

    public OID FdHeartbeat() {
        return this.failure_detector.FdHeartbeat();
    }

    public void FdNewCoordinator() {
        this.failure_detector.FdNewCoordinator();
    }
}

