

import java.io.*;
import java.util.*;
import JavaGroups.*;




public class GetStateTest implements Runnable {
    Channel        channel;
    int[]          state;    // dice results, it *is* serializable !
    Thread         getter=null;
    boolean        rc=false;


    
    public void Start() throws Exception {
	channel=new JChannel("UDP:PING:FD:GMS:STATE_TRANSFER");
	channel.SetOpt(Channel.GET_STATE_EVENTS, new Boolean(true));
	channel.Connect("TestChannel");

	System.out.println("Getting state");
	rc=channel.GetState(3000);
	
	if(rc == false) {
	    state=new int[3];
	    state[0]=1; state[1]=2; state[2]=3;
	}

	System.out.println("State is\n" + PrintState(state));
	Util.Sleep(2000);

	getter=new Thread(this, "Getter");
	getter.start();




	while(true) {
	    Message update=new Message(null, null, null);
	    int     index=(int)Math.abs(System.currentTimeMillis() % 3);
	    
	    try {
		update.SetBuffer(Util.ObjectToByteBuffer(new Integer(index)));
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	    System.out.println("Sending update for index " + index);
	    channel.Send(update);
	    Util.Sleep(100);
	}
       
    }


    public void run() {
	Object ret;

	try {
	    while(true) {
		ret=channel.Receive(0);
		System.out.println("ret=" + ret);
		if(ret instanceof Message) {
		    Message m=(Message)ret;
		    Integer index;
		    int     in;

		    try {
			index=(Integer)Util.ObjectFromByteBuffer(m.GetBuffer());
			in=index.intValue();
			System.out.println("state[" + in + "]=" + (int)(state[in]+1));
			state[index.intValue()]++;
		    }
		    catch(ClassCastException cast_ex) {
			System.out.println("Contents of buffer was no Integer !");
		    }
		    catch(Exception e) {
			System.err.println(e);
		    }
		    
		}
		else if(ret instanceof GetStateEvent) {
		    System.out.println("----> State transfer: " + ret);
		    channel.ReturnState(state);
		}
		else if(ret instanceof SetStateEvent) {
		    state=(int[])((SetStateEvent)ret).GetArg();
		}
	    }
	}
	catch(Exception e) {
	}
    }
    

    String PrintState(int[] vec) {
	StringBuffer ret=new StringBuffer();
	if(vec != null)
	    for(int i=0; i < vec.length; i++)
		ret.append("state[" + i + "]: " + vec[i] + "\n");
	return ret.toString();
    }


    public static void main(String[] args) {
	try {
	    new GetStateTest().Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

}
