
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import JavaGroups.*;




public class Topology extends Frame implements WindowListener, MembershipListener {
    private Vector         members=new Vector();
    private Graphics       g;
    private Font           font;
    private FontMetrics    fm;
    private Color          node_color=new Color(250, 220, 100);
    private boolean        coordinator=false;
    private final int      NormalStyle=0;
    private final int      CheckStyle=1;
    private final int      HeartbeatStyle=2;

    private final String   channel_name="DemoGrp";
    private Dispatcher     disp=null;
    private Object         my_addr=null;



    public Topology() {
	addWindowListener(this);
	g=getGraphics();
	fm=getFontMetrics(new Font("TimesRoman", Font.BOLD,12));
	font=new Font("TimesRoman",Font.BOLD,12);

    }


    public void AddNode(Object member) {
	Object tmp;
	for(int i=0; i < members.size(); i++) {
	    tmp=members.elementAt(i);
	    if(member.equals(tmp))
		return;
	}
	members.addElement(member);
	repaint();
    }


    public void RemoveNode(Object member) {
	Object tmp;
	for(int i=0; i < members.size(); i++) {
	    tmp=members.elementAt(i);
	    if(member.equals(tmp)) {
		members.removeElement(members.elementAt(i));
		break;
	    }
	}	
	repaint();
    }    


    public void DrawNode(Graphics g, int x, int y, String label, int style) {
	Color old=g.getColor();
	int width, height;
	width=fm.stringWidth(label) + 10;
	height=fm.getHeight()+5;

	g.setColor(node_color);

	g.fillRect(x, y, width, height);
	g.setColor(old);
	g.drawString(label, x+5, y+15);
	g.drawRoundRect(x-1, y-1, width+1, height+1, 10, 10);
	if(style == CheckStyle) {
 	   g.drawRoundRect(x-2, y-2, width+2, height+2, 10, 10);
	   g.drawRoundRect(x-3, y-3, width+3, height+3, 10, 10);
	}
    }



    public void DrawTopology(Graphics g) {
	int        x=20, y=50;
	String     label;
	Dimension  box=getSize();
	Color      old=g.getColor();
	
	if(coordinator) {
	    g.setColor(Color.cyan);
	    g.fillRect(11, 31, box.width-21, box.height-61);
	    g.setColor(old);
	}
	
	g.drawRect(10, 30, box.width-20, box.height-60);
	g.setFont(font);

	for(int i=0; i < members.size(); i++) {
	    label=members.elementAt(i).toString();
	    DrawNode(g, x, y, label, NormalStyle);
	    y+=50;
	}
	

	
    }

    
    public void paint(Graphics g) {
	DrawTopology(g);
    }


    /* ------------ Callbacks ------------- */


    public void ViewAccepted(View view) {
	Util.Print("ViewAccepted: members are " + view.GetMembers());
	SetState(view.GetMembers());
    }

    public void Suspect(Object suspected_mbr) {}

    public void Block() {}

    
    
    public void SetState(Vector mbrs) {
	members.removeAllElements();
	for(int i=0; i < mbrs.size(); i++)
	    AddNode(mbrs.elementAt(i));
	if(mbrs.size() <= 1 || (mbrs.size() > 1 && mbrs.elementAt(0).equals(my_addr)))
	    coordinator=true;
	else
	    coordinator=false;
	repaint();
    }
    



    public void CoordinatorChosen() {
	coordinator=true;
	repaint();
    }


    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	disp.Leave(channel_name, this);
	System.exit(0);
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}




    public void Start() throws Exception {
	disp=new Dispatcher(new JChannelFactory(), null);
	disp.SetMembershipListener(channel_name, this);
	disp.SetMethodLookup(new MethodLookupClos());
	my_addr=disp.GetAddress(channel_name);
	if(my_addr != null)
	    setTitle(my_addr.toString());
	disp.Join(channel_name, this);
	show();	
    }


    public static void main(String[] args) {	
	try {
	    Topology top=new Topology();
	    top.setLayout(null);
	    top.setSize(240,507);
	    top.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	    e.printStackTrace();
	}
    }



}


