
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;

import JavaGroups.Ensemble.*;
import JavaGroups.Util;


class Msg implements Serializable {
    int type;

    public Msg(int type) {this.type=type;}
}

public class EnsRecursive implements Hot_Callbacks {
    private String                 groupname="SyncCallTest";
    private Hot_Ensemble           ensemble=null;
    private Thread                 ens_thread=null;
    private Hot_GroupContext       group_id=null;
    private Hot_JoinOps            options=null;
    private int                    member_size=0;
    private boolean                first=true;



    public EnsRecursive() {
	try {
	    ensemble=new Hot_Ensemble();
	    ens_thread=new Thread(ensemble);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }



    public void go() {
	Hot_Error        rc;
	Hot_GroupContext tmp[]=new Hot_GroupContext[1];

	try {
	    ens_thread.start();
	    options=new Hot_JoinOps();
	    options.heartbeat_rate=5000;
	    options.transports="UDP";
	    //options.protocol=null;
	    options.properties="Gmp:Sync:Heal:Frag:Suspect:Flow:Total";
	    options.group_name=groupname;
	    options.params="suspect_max_idle=3:int;suspect_sweep=3.000:time";
	    options.conf=this;
	    options.use_properties=true;
	    rc=ensemble.Join(options, tmp);
	    if(rc != null) {
		System.err.println("Error in JOIN: " + rc);
		System.exit(-1);
	    }
	    group_id=tmp[0];
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

    private void CastMessage(int type) {
	Hot_Error rc;
	int       tmp[]=new int[1];

	rc=ensemble.Cast(group_id, new Hot_ObjectMessage(new Msg(type)), tmp);
	if(rc != null)
	    System.err.println("Error casting: " + rc);	
    }


    public void Start() {
	CastMessage(1);
    }




    public static void main(String[] args) {
	EnsRecursive draw;
	draw=new EnsRecursive();
	draw.go();
	try {
	    Thread.currentThread().sleep(2000);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	draw.Start();
    }





    /* --------------- Callbacks --------------- */


    private void Foo() {
	Util.Print("Foo");

	Util.Print("Casting message 2:");
	CastMessage(2);

	Util.Print("Sleeping for 3 seconds:");
	try {
	    Thread.currentThread().sleep(3000);
	    Util.Print("Done sleeping");
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

    private int counter=0;

    private void Bar() {
	Util.Print("Bar");
	counter++;
	if(counter > 5)
	    Util.DumpStack(true);
	CastMessage(1);
    }


    private void HandleMessage(Msg m) {
	System.out.println("Received message " + m.type);
	switch(m.type) {
	case 1:
	    Foo();
	    break;
	case 2:
	    Bar();
	    break;
	default:
	    System.err.println("HandleMessage: type " + m.type + " not known");
	    break;
	}
    }


    public synchronized void ReceiveCast(Hot_GroupContext gctx, Object env, 
			    Hot_Endpoint origin, Hot_Message msg) {
	Hot_Error rc;
	Msg       m;

	try {
	    m=(Msg)Util.ObjectFromByteBuffer(msg.getBytes());
	    HandleMessage(m);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	


    }


    public void ReceiveSend(Hot_GroupContext gctx, Object env, 
			    Hot_Endpoint origin, Hot_Message msg) {

	System.out.println("ReceiveSend()");
    }


    public void AcceptedView(Hot_GroupContext gctx, Object env, Hot_ViewState viewState) {
	if(first) {
	    System.out.println("My address is " + viewState.members[0]);
	    first=false;
	}
    }


    public void Heartbeat(Hot_GroupContext gctx, Object env, int rate) {

    }


    public void Block(Hot_GroupContext gctx, Object env) {
    }


    public void Exit(Hot_GroupContext gctx, Object env) {
	System.out.println("Received EXIT msg, exiting...");
	System.exit(0);
    }




}

