
import java.util.*;
import JavaGroups.*;

public class ChannelTest implements Runnable {
    private Channel channel=null;
    private Thread  mythread=null;


    public void Start() throws Exception {
	channel=new JChannel(null);
	channel.Connect("ExampleGroup");
	mythread=new Thread(this);
	mythread.start();
	for(int i=0; i < 50; i++) {
	    System.out.println("Casting msg #" + i);
	    channel.Send(new Message(null, null, new String("This is msg #" + i).getBytes()));
	    Thread.currentThread().sleep(100);
	}
	channel.Disconnect();
	mythread.stop();
    }


    public void run() {
	Object msg;
	while(true) {
	    try {
		msg=channel.Receive(0); // no timeout
		if(msg instanceof View)
		    System.out.println("--> NEW VIEW");
		else if(msg instanceof Message)
		    System.out.println("Received " + msg);
	    }
	    catch(ChannelNotConnected conn) {
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



    


    public static void main(String args[]) {
	ChannelTest test;
	try {
	    test=new ChannelTest();
	    test.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
   
}
